/*
 * Decompiled with CFR 0.152.
 */
package org.objectweb.carol.cmi.compiler;

import java.lang.reflect.Method;
import org.objectweb.carol.cmi.compiler.ClassConf;
import org.objectweb.carol.cmi.compiler.CompilerException;
import org.objectweb.carol.cmi.compiler.MethodProto;

public class MethodConf {
    private MethodProto methodProto;
    private ClassConf ccc;
    private String balancer;
    private Method method = null;
    private String paramString;
    private String paramNamesString;
    private String throwsString;

    public MethodConf(ClassConf ccc, MethodProto mp, String balancerName) {
        this.ccc = ccc;
        this.methodProto = mp;
        if (balancerName == null) {
            balancerName = ccc.getBalancer();
        }
        this.balancer = balancerName;
    }

    public ClassConf getClassConf() {
        return this.ccc;
    }

    public MethodProto getMethodProto() {
        return this.methodProto;
    }

    public String getBalancer() {
        return this.balancer;
    }

    public Method getMethod() {
        return this.method;
    }

    public String getMthName() {
        return this.method.getName();
    }

    public String getReturnTypeName() {
        return this.method.getReturnType().getName();
    }

    public String getParamString() {
        if (this.paramString != null) {
            return this.paramString;
        }
        Class<?>[] params = this.method.getParameterTypes();
        String s = "";
        int i = 0;
        while (i < params.length) {
            s = s.equals("") ? params[i].getName() + " param" + (i + 1) : s + ", " + params[i].getName() + " param" + (i + 1);
            ++i;
        }
        this.paramString = s;
        return s;
    }

    public String getParamNamesString() {
        if (this.paramNamesString != null) {
            return this.paramNamesString;
        }
        int len = this.method.getParameterTypes().length;
        String s = "";
        int i = 0;
        while (i < len) {
            s = s.equals("") ? "param" + (i + 1) : s + ", param" + (i + 1);
            ++i;
        }
        this.paramNamesString = s;
        return s;
    }

    public String getThrowsString() {
        if (this.throwsString != null) {
            return this.throwsString;
        }
        Class<?>[] ex = this.method.getExceptionTypes();
        String s = "";
        int i = 0;
        while (i < ex.length) {
            s = s.equals("") ? ex[i].getName() : s + ", " + ex[i].getName();
            ++i;
        }
        this.throwsString = s;
        return s;
    }

    public String getDeclItfName() {
        return this.method.getDeclaringClass().getName();
    }

    public boolean returnsVoid() {
        return this.method.getReturnType().equals(Void.TYPE);
    }

    public void setMethod(Method method) throws CompilerException {
        if (this.method != null) {
            throw new CompilerException("internal error");
        }
        this.method = method;
    }
}

