(function () {
	importer.Bitbucket = importer.Bitbucket || {};

	importer.Bitbucket.currentProjectName = "";
	importer.Bitbucket.fetchNotify = function (fetchSummaryProgress) {
		var that = this;
		AJS.log("fetchNotify");

		var getProgress = function (currentProjects, totalProjects) {
			var percentage;
			if (totalProjects !== 0) {
				percentage = (currentProjects / totalProjects) * 100;
			} else {
				percentage = 0;
			}
			percentage = Math.round(percentage);
			var message = currentProjects + "/" + (totalProjects != null ? totalProjects : "?");
			return {percentage: percentage, message: message};
		};

		var completeCurrentBar = function () {
			if (importer.Bitbucket.currentProjectName !== '') {
				//finish old progress excluding first one
				AJS.$('.fetchSummaryProgress .fetchCurrentProgress:last .currentBar').progressBar(100);
				AJS.$('.fetchSummaryProgress .fetchCurrentProgress:last p .currentProjectMessage').text('100%');
				AJS.$('.fetchSummaryProgress .fetchCurrentProgress:last p .currentProjectMessageConstPost').text(" - ready");
			}

		};

//          update global progress values
		var progress = getProgress(fetchSummaryProgress.currentProjects, fetchSummaryProgress.totalProjects);
		AJS.$("#importedProjects").text(progress.message);

		var fetchCurrentProgress = fetchSummaryProgress.currentFetchProgress;
		if (importer.Bitbucket.currentProjectName !== fetchCurrentProgress.repositoryName) {
			completeCurrentBar();


			importer.Bitbucket.currentProjectName = fetchCurrentProgress.repositoryName;

			//create new progress
			AJS.$('.fetchCurrentProgress:first').
					clone(false).
					removeClass('hidden').
					appendTo('.fetchSummaryProgress');

			AJS.$('.fetchSummaryProgress .fetchCurrentProgress:last p .currentProjectMessageConstPre').text(" "
					+ fetchCurrentProgress.repositoryName);
			AJS.$('.fetchSummaryProgress .fetchCurrentProgress:last .currentBar').attr('id', fetchCurrentProgress.repositoryName.replace(/\//gi, "_")
					+ "Bar")
		}

//update current progress bar values
		var currentProgress = getProgress(fetchCurrentProgress.currentIssues, fetchCurrentProgress.totalIssues);
		AJS.$('.fetchSummaryProgress .fetchCurrentProgress:last .currentBar').progressBar(currentProgress.percentage);
		AJS.$('.fetchSummaryProgress .fetchCurrentProgress:last p .currentProjectMessage').text(currentProgress.percentage
				+ '%');
		AJS.$('.fetchSummaryProgress .fetchCurrentProgress:last p .currentProjectMessageConstPost').text(" - "
				+ fetchCurrentProgress.currentOperation);

		if (fetchSummaryProgress.currentProjects == fetchSummaryProgress.totalProjects) {
			completeCurrentBar();
			document.location.href = "ImporterFieldMappingsPage!default.jspa?externalSystem=com.atlassian.jira.plugins.jira-importers-bitbucket-plugin%3ABitbucketImporterKey";
		} else {
			setTimeout(function() {
				return importer.Bitbucket.pollProgress.call(that);
			}, 2000);
		}
	};

	importer.Bitbucket.pollProgress = function () {
		var that = this;
		AJS.log("Polling progress");
		AJS.$.ajax({
			url: contextPath
					+ "/rest/bitbucket-importer-plugin/1.0/fetchData/com.atlassian.jira.plugins.jira-importers-bitbucket-plugin:BitbucketImporterKey/progress",
			type: "get",
			data: { "atl_token": "$esc.javascript($atl_token)"}
		}).done(function (data) {
					if (data.error == null) {
						AJS.$("#errorBox").add("hidden");
						importer.Bitbucket.fetchNotify(data);
					} else {
						AJS.$("#errorMessage").text("Fetching data from Bitbucket failed: " + data.error);
						AJS.$("#errorBox").removeClass("hidden");

						AJS.$('.buttons-container-cancel').addClass("hidden");
						AJS.$('.fetchSummaryProgress').addClass("hidden");
						AJS.$('.loadingMessage').addClass("hidden");

						AJS.$('.buttons-container-finish').removeClass("hidden");
					}
				}).fail(function (jqXHR, textStatus, errorThrown) {
					AJS.log(errorThrown);
					AJS.$("#errorMessage").text("Unable to check fetch progress (" + errorThrown + ")");
					AJS.$("#errorBox").removeClass("hidden");

					setTimeout(function() {
						return importer.Bitbucket.pollProgress.call(that);
					}, 2000);
				});
	};

	AJS.$(document).ready(function () {
		importer.Bitbucket.pollProgress();
	});

})();
