function safelyRunFunction (func) {
    try {
        func();
    } catch (exc) {
    }
}

var collectorInitializationFunction = function ($) {
    var $collectorDialog = $(".collector-dialog");
    var $auiform = $(".collector-dialog form#jic-collector-form");
    var $messageContainer = $("<div></div>").addClass("msg-container shadowed");
    $collectorDialog.prepend($messageContainer);

    var defaultFieldValues = {};
	var errorContainerMap = {};

	var $customCollectorForm = $(".custom-collector");
	$customCollectorForm.addClass("visuallyhidden");

    function informParentCollectorHasLoaded() {
        window.parent.postMessage("collectorLoaded", "*");
    }

    function postHeightToParent() {
        var $content = $('.content-body');
        $content.css("bottom", "auto");
        // 107px is the height of the footer + header
        var height = 107 + $('.content-body').outerHeight();
        $content.css("bottom", "");
        window.parent.postMessage(JSON.stringify({
            frameHeight: height
        }), '*');
    }

    function hasErrors(response) {
        var hasErrors = false;
        if (response) {
            hasErrors = (typeof response.errors === "object");
            hasErrors = hasErrors || (typeof response.errorMessages !== "undefined");
        }
        return hasErrors;
    }

    function hasAttachmentError(response) {
        return (typeof response.attachment_error !== "undefined");
    }

    var displayAttachmentFailureWarning = function() {
        AJS.messages.error($messageContainer, {
            title: AJS.I18n.getText("collector.plugin.template.error"),
            body: AJS.I18n.getText("collector.plugin.template.attachment.failure"),
            closeable: false
        });
    };

    var displayGeneralError = function(message) {
        AJS.messages.error($messageContainer, {
            title: AJS.I18n.getText("collector.plugin.template.error"),
            body: message,
            closeable: true
        });
	};

	var errorHandler = function(errorsObject) {
        var missingFieldDetected = false;
        var messages = "";
        if (hasErrors(errorsObject)) {
            if (!$.isArray(errorsObject.errorMessages)) {
                errorsObject.errorMessages = [];
            }

            if (!$.isEmptyObject(errorsObject.errors)) {
                $.each(errorsObject.errors, function(field, error) {
                    var errorContainer = errorContainerMap[field] || $auiform.find("#" + field).closest(".field-group,form");
                    if (errorContainer === "undefined" || errorContainer.length === 0) {
                        missingFieldDetected = true;
                        errorsObject.errorMessages.push(AJS.format(AJS.I18n.getText("collector.plugin.template.error.field"), field) + error);
                    }
                    errorContainer.append("<div class=\"error\">" + error + "</div>");
                });
            }

            if (errorsObject.errorMessages.length) {
                displayGeneralError(AJS.I18n.getText("collector.plugin.template.error.generalmsg"));
            } else if (missingFieldDetected || messages) {
                displayGeneralError(messages);
            }
            $auiform.removeClass("disabled").find(".submit-button").removeAttr("disabled");
        } else if (hasAttachmentError(errorsObject)) {
            displayAttachmentFailureWarning();
        } else {
            if (errorsObject.errorStatus) messages += "(AJAX request failed with " + errorsObject.errorStatus + ")";
            displayGeneralError(messages);
        }
    };

    var ajaxErrorHandler =  function(xhr, status, errorThrown) {
        AJS.log("Error on AJAX transmission...");
        AJS.log(arguments);
        var errorsObject = {};
        try {
            $.extend(errorsObject, JSON.parse(xhr.responseText));
        } catch (e) {}
        if (!$.isArray(errorsObject.errorMessages)) errorsObject.errorMessages = [];

        if (status === "timeout" || (xhr.error === "timeout")) {
            errorsObject.errorMessages.push(AJS.I18n.getText("collector.plugin.template.error.timeout"));
        }
        if (errorThrown) errorsObject.errorMessages.push("AJAX error thrown: " + errorThrown);

        errorsObject.errorStatus = "http: " +xhr.status + ", status: " + status;
        errorHandler(errorsObject);
    };

    var showErrorMessage = function(fieldId, errorMessage) {
        $auiform.find("#" + fieldId).after("<div class=\"error\">" + errorMessage + "</div>");
    };

    var setDefaultValues = function() {
        if (!$.isEmptyObject(defaultFieldValues)) {
            for (var fieldId in defaultFieldValues) {
				if (!defaultFieldValues.hasOwnProperty(fieldId)) continue;
				var fieldValue = defaultFieldValues[fieldId];
				var id = fieldId.replace(/(:|\.)/g, '\\$1');
				var field = $auiform.find("#" + id).add($auiform.find('input[type="radio"],input[type="checkbox"]').filter('[name="' + fieldId + '"]'));
				if (field.length != 0) {
                    field.val(defaultFieldValues[fieldId]);
				} else {
					var addHiddenField = function (idx, value) {
						//noinspection JSReferencingMutableVariableFromClosure
						$('<input type="hidden">').attr("name", fieldId).val(value).appendTo($auiform);
					};
					if ($.isArray(fieldValue)) {
						$.each(fieldValue, addHiddenField);
					} else {
						addHiddenField(undefined, fieldValue);
					}

				}
			}
        }
    };

	var setFocusOnFirstTextElement = function () {
		if ($(".dont-default-focus").size() === 0) {
			$(window).focus();
			$("input.text:visible, textarea.textarea:visible").first().focus();
		}
	};

    var displayErrorIfThirdPartyCookiesAreDisabled = function () {
        // cookies should not be empty - it should contain at least xsrf token
        // if it's empty, we have third-party cookies disabled
        if (document.cookie === "") {
            AJS.messages.error($messageContainer, {
                body: AJS.I18n.getText("collector.plugin.collector.third.party.cookies.disabled"),
                closeable: true,
                id: "collector-third-party-cookies-error"
            });
        }
    };

    $auiform.ajaxForm({
        skipEncodingOverride:true,
        dataType: "json",
        timeout: 360000,
        beforeSubmit: function(arr, $form, options) {
            $collectorDialog.find(".error:not(#collector-third-party-cookies-error)").remove();

            //basic validation.
            if(!AJS.params.customTemplate) {
                var $description = $form.find("#description"), $rating = $form.find("input[name=rating]");
                if($rating.length > 0) {
                    var result = true;

                    var rating = $form.find("input[name=rating]:checked").val();
                    if(!rating || rating.length == 0) {
                        showErrorMessage("feedback-rating",AJS.I18n.getText("collector.plugin.form.error.rating"));
                        result = false;
                    }

                    var descGood = $.trim($form.find("#description-good").val());
                    if (!descGood || descGood.length == 0) {
                        showErrorMessage("description-good",AJS.I18n.getText("collector.plugin.form.error.what.you.like"));
                        result = false;
                    }

                    var descBad = $.trim($form.find("#description-bad").val());
                    if (!descBad|| descBad.length == 0) {
                        showErrorMessage("description-bad",AJS.I18n.getText("collector.plugin.form.error.what.needs.improvement"));
                        result = false;
                    }

                    if (!result) {
                        return false;
                    }
                }
                if($description.length === 1) {
                    var desc = $.trim($description.val());
                    if(!desc || desc.length == 0) {
                        showErrorMessage("description",AJS.I18n.getText("collector.plugin.form.error.what.went.wrong"));
                        return false;
                    }
                }
            }

            // Don't send the browser information if user did not agree to it.
            if ($("#recordWebInfoConsent").prop('checked') !== true) {
                $("#webInfo").val("");
            }

            $form.addClass("disabled").find(".submit-button").attr("disabled", "disabled");
            return true;
        },
        success: function(response, status, xhr, $form) {
            var successMsg;

            if(hasErrors(response)) {
                AJS.log("Received custom errors from server...");
                AJS.log(arguments);
                response.errorStatus = status;
                errorHandler(response);
                return;
            }

            if (hasAttachmentError(response)) {
                AJS.log("Received attachment error(s) from server...");
                AJS.log(arguments);
                errorHandler(response);
                return;
            }

            if(response.url !== undefined) {
                var linkHtml = "<a class=\"issue-key\" target=\"_blank\" href=\"" + response.url + "\">" + response.key + "</a>";
                successMsg = "<p>" + AJS.format(AJS.I18n.getText("collector.plugin.template.thanks.recorded"), linkHtml) + "</p>";
            } else {
                successMsg = "<p>" + AJS.I18n.getText("collector.plugin.template.thanks.no.permission") + "</p>";
            }
            AJS.messages.success($messageContainer, {
                title: AJS.I18n.getText("collector.plugin.template.thank.you"),
                body: successMsg,
                closeable: false
            });
            setTimeout(function() {
                window.parent.postMessage("cancelFeedbackDialog", "*");
            }, 5000);
        },
        error: ajaxErrorHandler
    });

    var closeDialog = function(e) {
        e.preventDefault();
        window.parent.postMessage("cancelFeedbackDialog", "*");
    };

    $(window).keydown(function(e) {
        if (e.keyCode === 27) {
            closeDialog(e);
        }
    });
    $(".dialog-button-panel .cancel").click(function(e) {
        closeDialog(e);
    });

    $(".aui-message.custom-msg a").each(function() {
        $(this).attr("target", "_blank");
    });

    $("#not-you-lnk").click(function(e) {
        e.preventDefault();
        $("#name-group").show();
        $("#email-group").show();
        $(".login-msg").hide();
    });

    $("#show-recorded-web-info").click(function(e) {
        e.preventDefault();
        $("#show-recorded-web-info").addClass("hidden");
        $("#recorded-web-info").removeClass("hidden");
        var $webInfo = $("#webInfo");
        $webInfo.height($webInfo[0].scrollHeight + 5);
    });

    // we have to run it safely, because it may fail in cloud if third-party cookies are disabled
    safelyRunFunction(function () {
        AJS.InlineAttach.Renderers.container = function () {
            return $("<div class='checkbox'/>");
        };
        AJS.InlineAttach.AjaxPresenter.DEFAULT_URL = "@contextPath/rest/collectors/1.0/tempattachment/" + AJS.params.collectorId;
        AJS.InlineAttach.FormPresenter.DEFAULT_URL = "@contextPath/rest/collectors/1.0/tempattachment/multipart/" + AJS.params.collectorId;
    });

    displayErrorIfThirdPartyCookiesAreDisabled();

    $(window).bind("message", function(e) {
        // *********************** DANGER *******************
		try {
			var parsedMessage = JSON.parse(e.originalEvent.data);
			//CAREFUL! NEVER EVER eval any text here or it's a massive security hole.  Always ensure it's properly
			//escaped before inserting into the DOM!
			$("#webInfo").val(parsedMessage.feedbackString);
			// *********************** DANGER *******************
			defaultFieldValues = parsedMessage.fieldValues;
		} catch (ex) {
			// do nothing in case "cancelFeedbackDialog" message
		}

        // Exit early if we're not interested in the message
        if (!parsedMessage || parsedMessage.messageType !== "collector.iframe.loaded") {
            return;
        }

        if(AJS.params.customTemplate) {
            $.ajax({
                url: "@contextPath/secure/CreateFields!default.jspa?decorator=none&projectKey=" + AJS.params.projectKey + "&issueType=" + AJS.params.issueType,
                contentType: "application/json"
            })
                .done(function(data) {
                    var $container = $(".custom-fields-container");
                    var fieldMap = {};
                    var customLabels = {};

                    var setCustomLabel = function(id, field) {
                        var $field = (field instanceof $) ? field : $(field);
                        var $label, $textNode;
                        if (customLabels[id]) {
                            $label = $field.children("label, legend").first();
                            if ($label.is("legend")) $label = $label.find("span");
                            $textNode = $label.contents().first();
                            $textNode.replaceWith(document.createTextNode(customLabels[id]));
                        }
                    };

                    if(AJS.params.customLabels) {
                        customLabels = JSON.parse(AJS.params.customLabels);
                    }
                    $(data.fields).each(function(i, field) {
                        fieldMap[field.id] = field;
                    });

                    $(".contact-form-fields").each(function(index, field) {
                        setCustomLabel(field.id, field);
                    });

                    $(JSON.parse(AJS.params.fields)).each(function(i, field) {
                        if(fieldMap[field]) {
                            var $field = $(fieldMap[field].editHtml);
                            setCustomLabel(field, $field);
							$field = $field.appendTo($container);
							function findContainer(html) {
								var group = html.filter(".field-group,fieldset.group");
								if (group.length > 0) {
									return group.last();
								}

								group = html.find(".field-group,fieldset.group");
								if (group.length > 0) {
									return group.last();
								}

								var any = html.filter(":has(input)");
								if (any.length > 0) {
									return any.last();
								}

								return $container;
							}
							errorContainerMap[field] = findContainer($field);
                        }
                    });
					// set default values on fields if they haven't already been set
					setDefaultValues();

					//todo: This can be removed in JIRA 4.4.4 and replaced by:
                    //JIRA.trigger(JIRA.Events.NEW_CONTENT_ADDED, [$container]);
                    var dialogStub = {
                        get$popupContent: function() {
                            return $container;
                        }
                    };

                    // we have to run it safely, because it may fail in cloud if third-party cookies are disabled
                    safelyRunFunction(function () {
                        AJS.InlineAttach.AjaxPresenter.DEFAULT_URL = "@contextPath/rest/collectors/1.0/tempattachment/" + AJS.params.collectorId;
                        AJS.InlineAttach.FormPresenter.DEFAULT_URL = "@contextPath/rest/collectors/1.0/tempattachment/multipart/" + AJS.params.collectorId;
                    });

                    $(document).trigger("dialogContentReady", [dialogStub]);
					$customCollectorForm.removeClass("visuallyhidden");
					setFocusOnFirstTextElement();
                })
                .fail(function() {
					$customCollectorForm.removeClass("visuallyhidden");
                    AJS.log("Custom template AJAX failure");
                    ajaxErrorHandler.apply(this, arguments);
                })
                .always(function() {
                    informParentCollectorHasLoaded();
                    postHeightToParent();
                });
        } else {
            informParentCollectorHasLoaded();
            postHeightToParent();
			// set default values on fields if they haven't already been set
			setDefaultValues();
			setFocusOnFirstTextElement();
		}
    });
};

// jQuery.ready won't be called if other script which is using this function fail
// this may happen if we disable third-party cookies in Chrome/Safari (it also disables localstorage)
(function func ($) {
    if (document.readyState !== "loading") {
        collectorInitializationFunction($);
    } else {
        document.addEventListener("DOMContentLoaded", function () {
            collectorInitializationFunction($);
        });
    }
})(AJS.$);