UPM.define('EvalEulaDialog',
    [
        'UpmDialog',
        'EvalEulaDialogTemplate',
        'UpmEnvironment'
    ],
    function(UpmDialog,
             evalEulaDialogTemplate,
             environment) {

    // Dialog for confirming the Marketplace EULA and/or an add-on EULA.  The model for the dialog is the add-on model.
    // Set the "needAtlassianCustomerAgreement" option to true if the Atlassian Customer agreement needs to be accepted (trumps mpac eula option)
    // Set the "needMarketplaceEula" option to true if the Marketplace EULA needs to be accepted.

    return UpmDialog.extend({
        template: evalEulaDialogTemplate,

        _getData: function() {
            return {
                pluginName: this.model.getName(),
                pluginEulaUrl: this.model.getEulaUrl(),
                requireMpacEula: this.options.needMarketplaceEula,
                requireAtlassianCustomerAgreement: this.options.needAtlassianCustomerAgreement,
                showRedirectPrompt: this.options.showRedirectPrompt
            };
        },

        _onConfirm: function() {
            if (!this.options.needAtlassianCustomerAgreement && this.options.needMarketplaceEula) {
                environment.setMarketplaceEulaAccepted();
            }
            UpmDialog.prototype._onConfirm.apply(this);
        }
    });
});
