UPM.define('AddonWatchLinksView',
    [
        'jquery',
        'AddonWatchErrorTemplate',
        'AddonWatchLinksTemplate',
        'BaseView',
        'CollectionItemRenderingStrategy'
    ], function($,
                addonWatchErrorTemplate,
                addonWatchLinksTemplate,
                BaseView,
                CollectionItemRenderingStrategy) {

    "use strict";

    /**
     * Provides UI elements for showing and changing the "watching" status of an add-on.
     * Getting the status requires a separate REST request, so the view first initializes itself in an empty
     * state, then makes the REST request via the add-on model and finishes rendering itself when ready.
     */
    return BaseView.extend({

        template: addonWatchLinksTemplate,
        
        renderingStrategy: CollectionItemRenderingStrategy,
        
        events: {
            'click a': '_doWatchOrUnwatch'
        },

        _getData: function() {
            return {
                watchingModel: this.watchingModel && this.watchingModel.toJSON()
            };
        },

        _postRender: function() {
            var me = this;
            if (!this.watchingModel) {
                this.model.loadWatchingModel()
                    .done(function(wm) {
                        me.watchingModel = wm;
                        me.listenTo(me.watchingModel, 'change:watching', me.render);
                        me.render();
                    });
            }
        },

        _doWatchOrUnwatch: function(e) {
            var shouldWatch = $(e.target).hasClass('upm-plugin-watch-link'),
                me = this;
            e.preventDefault();
            this.watchingModel.updateWatching(shouldWatch)
                .fail(function() {
                    me.model.triggerMessage({
                        type: 'error',
                        message: addonWatchErrorTemplate({ plugin: me.model.toJSON() }).trim()
                    });
                });
        }
    });
});
