AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var C=require("workflow-designer/dialogs/delete-transition-dialog-view");var B=require("workflow-designer/status-model");var K=require("workflow-designer/status-view");var E=require("workflow-designer/workflow-model");var A=require("workflow-designer/transition-model");var D=require("workflow-designer/transition-view");var I=require("workflow-designer/canvas-model");var H=require("workflow-designer/policy/canvas/panning-single-selection-policy");var F=require("workflow-designer/test-utilities");var J=require("workflow-designer/underscore");var G=require("workflow-designer/draw-2d");module("TransitionView",{createStatusView:function(L,M){return new K(J.defaults({},M,{canvas:this.canvas,model:new B(L),workflowModel:new E()})).render()},createTestData:function(L){this.sourceView=new K({canvas:this.canvas,model:new B({x:10,y:0}),workflowModel:new E()}).render();this.targetView=new K({canvas:this.canvas,model:new B({x:200,y:0}),workflowModel:new E()}).render();this.transitionModel.set({source:this.sourceView.model,target:this.targetView.model});L=J.defaults({},L,{canvas:this.canvas,canvasModel:this.canvasModel,model:this.transitionModel,sourceView:this.sourceView,targetView:this.targetView,workflowModel:this.workflowModel});this.transitionView=new D(L);this.transitionView.requestResponse.setHandler("isSelected",function(){return false});this.transitionView.render()},createTransitionView:function(L,M){return new D(J.defaults({},M,{canvas:this.canvas,canvasModel:new I({},{workflowModel:this.workflowModel}),model:new A(L),workflowModel:this.workflowModel})).render()},deselectTransition:function(){this.canvas.selectFigure(null);this.transitionView.requestResponse.setHandler("isSelected",function(){return false})},selectTransition:function(){this.canvas.selectFigure(this.transitionView._connection);this.transitionView.requestResponse.setHandler("isSelected",function(){return true})},setup:function(){this.sandbox=sinon.sandbox.create();this.sandbox.stub(C.prototype,"show");function L(){return new G.geo.Rectangle(0,0,0,0)}this.canvas=F.testDraw2DCanvas();this.transitionModel=new A({name:"Transition"});this.workflowModel=new E();this.canvasModel=new I({},{workflowModel:this.workflowModel});this.canvasModel.set("showTransitionLabels",false);this.canvas.installEditPolicy(new H(L))},teardown:function(){this.sandbox.restore()},transitionIsHighlighted:function(){return this.transitionView.isHighlighted()&&this.transitionView._connection.textIsVisible()},transitionIsSelected:function(L){return L._connection.getColor().hash()==="#1A8CFF"}});test("appearSelected()",function(){this.createTestData();this.sandbox.spy(this.transitionView._connection,"appearSelected");this.transitionView.appearSelected();equal(this.transitionView._connection.appearSelected.callCount,1,"The transition's connection appears selected")});test("destroy() displays a DeleteTransitionDialogView",function(){var M,L=this.sandbox.stub(C.prototype,"initialize");this.createTestData();this.transitionView.destroy();equal(L.callCount,1,"A DeleteTransitionDialogView was created");M=L.args[0];equal(M.length,1,"It was passed a single argument");ok(M[0].transitionModel===this.transitionModel,"It was passed the correct TransitionModel");ok(M[0].workflowModel===this.workflowModel,"It was passed the correct WorkflowModel")});test("Reconnection triggers a reconnect event",function(){var L=sinon.spy();this.createTestData();this.transitionView.bind("reconnect",L);this.transitionView._connection.onReconnect();ok(L.called,"A reconnect event was triggered")});test("The label is not visible until the transition has a valid name",function(){this.createTestData();this.transitionModel.unset("name");sinon.stub(this.transitionView,"isSelected");ok(!this.transitionView._connection.textIsVisible(),"The transition's label isn't visible if it doesn't have a valid name");this.transitionView.isSelected.returns(true);this.transitionView.render();ok(!this.transitionView._connection.textIsVisible(),"The transition's label is not visible for selected transitions wihtout a valid name");this.transitionView.isSelected.returns(false);this.transitionView._highlight();ok(!this.transitionView._connection.textIsVisible(),"The transition's label is not visible for highlighted transitions wihtout a valid name");this.transitionView.unhighlight();this.transitionModel.set("name","Valid Name");this.selectTransition();this.transitionView.render();ok(this.transitionView._connection.textIsVisible(),"The transition's label is visible for selected transitions with a valid name");this.deselectTransition();this.transitionView._highlight();ok(this.transitionView._connection.textIsVisible(),"The transition's label is visible for highlighted transitions with a valid name");this.transitionView.unhighlight()});test("The label is hidden while connected statuses are being dragged",function(){this.createTestData();this.sourceView.trigger("highlight");ok(this.transitionIsHighlighted(),"The transition is highlighted when its source status is hovered");this.sourceView.trigger("drag");ok(!this.transitionView._connection.textIsVisible(),"The transition's label is not visible when its source status is being dragged");this.sourceView.trigger("dragEnd");ok(this.transitionView._connection.textIsVisible(),"The transition's label is visible after the source status has finished being dragged");this.targetView.trigger("highlight");ok(this.transitionIsHighlighted(),"The transition is highlighted when its target status is hovered");this.targetView.trigger("drag");ok(!this.transitionView._connection.textIsVisible(),"The transition's label is not visible when its target status is being dragged");this.targetView.trigger("dragEnd");ok(this.transitionView._connection.textIsVisible(),"The transition's label is visible after the target status has finished being dragged")});test("The label is updated after changing the transition's name",function(){this.createTestData();ok(this.transitionView._connection._label.getText().indexOf("Transition")>-1,"The label's text is correct");this.transitionModel.set("name","Updated Transition");ok(this.transitionView._connection._label.getText().indexOf("Updated Transition")>-1,"The label's text is correct after changing the transition's name")});test("The transition is highlighted on hover",function(){this.createTestData();ok(!this.transitionIsHighlighted(),"The transition is not highlighted by default");this.transitionView._connection.onMouseEnter();ok(this.transitionView.isHighlighted(),"The transition is highlighted on hover");this.transitionView._connection.onMouseLeave();ok(!this.transitionIsHighlighted(),"The transition is not highlighted after the mouse leaves")});test("The transition is highlighted when its status is hovered",function(){this.createTestData();ok(!this.transitionIsHighlighted(),"The transition is not highlighted by default");this.sourceView.trigger("highlight");ok(this.transitionIsHighlighted(),"The transition is highlighted when its source status is hovered");this.sourceView.trigger("unhighlight");ok(!this.transitionIsHighlighted(),"The transition is not highlighted when the mouse leaves its source status");this.targetView.trigger("highlight");ok(this.transitionIsHighlighted(),"The transition is highlighted when its target status is hovered");this.targetView.trigger("unhighlight");ok(!this.transitionIsHighlighted(),"The transition is not highlighted when the mouse leaves its target status")});test("The transition is highlighted when either of its statuses is selected",function(){this.createTestData();this.canvas.selectFigure(this.sourceView._getFigure());ok(this.transitionIsHighlighted(),"The transition is highlighted");this.transitionView._connection.onMouseLeave();ok(this.transitionIsHighlighted(),"The transition is still highlighted after the mouse leaves")});test("Selected transitions remain selected when the mouse leaves",function(){this.createTestData();ok(!this.transitionIsSelected(this.transitionView),"The transition does not appear selected");this.selectTransition();ok(this.transitionIsSelected(this.transitionView),"The transition appears selected after selection");this.transitionView._connection.onMouseLeave();ok(this.transitionIsSelected(this.transitionView),"The transition appears selected after mouse leaves");this.deselectTransition();ok(!this.transitionIsSelected(this.transitionView),"The transition does not appear selected after deselection")});test("The transition's sourceAngle and targetAngle attributes are automatically calculated",function(){this.createTestData();equal(this.transitionModel.get("sourceAngle"),this.sourceView.getAngleToPort(this.sourceView.getPortForAngle(0)),"The transition's sourceAngle attribute was set");equal(this.transitionModel.get("targetAngle"),this.targetView.getAngleToPort(this.targetView.getPortForAngle(180)),"The transition's targetAngle attribute was set")});test("The label is shown depending on the value of user preference 'showTransitionLabels'",function(){this.createTestData();this.canvasModel.set("showTransitionLabels",true);ok(this.transitionView._connection.textIsVisible(),"Label is visible");this.canvasModel.set("showTransitionLabels",false);ok(!this.transitionView._connection.textIsVisible(),"Label is not visible")});test("Double clicking a transition initiates editing",function(){var L=this.sandbox.stub(D.prototype,"edit");this.createTestData();this.transitionView._connection.onDoubleClick();equal(L.callCount,1,"TransitionView#edit() was called after double clicking the connection");this.transitionView._connection._label.onDoubleClick();equal(L.callCount,2,"TransitionView#edit() was called after double clicking the connection's label")});test("Double clicking a transition doesn't initiate editing when immutable",function(){var M=this.sandbox.stub(D.prototype,"edit"),L;this.createTestData();L=this.createTransitionView({source:this.sourceView.model,target:this.targetView.model},{immutable:true,sourceView:this.sourceView,targetView:this.targetView});L._connection.onDoubleClick();equal(M.callCount,0,"TransitionView#edit() wasn't called")});test('The connection is added to the "selected-transition" layer on selection',function(){var M=this.canvas.getLayer("selected-transition"),L=this.canvas.getLayer("transitions");this.createTestData();sinon.spy(M,"addFigure");sinon.spy(L,"addFigure");this.transitionView.select();equal(M.addFigure.callCount,1,'The "selected-transition" layer\'s #addFigure() method was called');ok(M.addFigure.args[0][0]===this.transitionView._connection,"It was passed the correct figure");this.transitionView.deselect();equal(L.addFigure.callCount,1,'The "transitions" layer\'s #addFigure() method was called');ok(L.addFigure.args[0][0]===this.transitionView._connection,"It was passed the correct figure")});test('The connection is added to the "transitions" layer',function(){var L=this.canvas.getLayer("transitions");sinon.spy(L,"addFigure");this.createTestData();equal(L.addFigure.callCount,1,'The "transitions" layer\'s #addFigure() method was called');ok(L.addFigure.args[0][0]===this.transitionView._connection,"It was passed the correct figure")});test("The connection's positionArrow method is called on selection",function(){this.createTestData();sinon.spy(this.transitionView._connection,"positionArrow");this.transitionView.select();equal(this.transitionView._connection.positionArrow.callCount,1,"The connection's positionArrow() method was called")});test("resetConnection sets the connection based on the current model",function(){var L,M;this.createTestData();L=this.transitionView.getConnection().getSource();M=this.transitionView.getConnection().getTarget();this.transitionView.getConnection().setSource(null);this.transitionView.getConnection().setTarget(null);this.transitionView.resetConnection();ok(J.isEqual(this.transitionView.getConnection().getSource(),L),"Original connection source was restored");ok(J.isEqual(this.transitionView.getConnection().getTarget(),M),"Original connection target was restored")});test("unhighlight()",function(){this.createTestData();this.sandbox.spy(this.transitionView._connection,"unhighlight");this.transitionView.unhighlight();equal(this.transitionView._connection.unhighlight.callCount,1,"The transition's connection was unhighlighted")})});