define("workflow-designer/layout/locator/looped-transition-locator", [
    "workflow-designer/draw-2d"
], function(
    draw2d
) {
    /**
     * Gap between transitions.
     *
     * @inner
     * @constant
     * @type {number}
     * @default
     */
    var heightGap = 15;

    return draw2d.layout.locator.Locator.extend(
    /** @lends JIRA.WorkflowDesigner.Layout.Locator.LoopedTransitionLocator# */
    {
        /**
         * Relocate a child figure.
         *
         * @param {number} index The child figure's index.
         * @param {draw2d.Figure} target The child figure.
         */
        relocate: function (index, target) {
            var container = target.getParent(),
                containerBoundingBox = container.getBoundingBox(),
                transitionBoundingBox = target.getBoundingBox(),
                transitionHeight = transitionBoundingBox.getHeight(),
                transitionRelativeTop = heightGap + (index * (heightGap + transitionHeight));

            target.setPosition(containerBoundingBox.getWidth()/2 - (transitionBoundingBox.getWidth()/2), transitionRelativeTop);
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.Layout.Locator.LoopedTransitionLocator", null, require("workflow-designer/layout/locator/looped-transition-locator"));