AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var D=require("workflow-designer/dialogs/delete-status-dialog-view");var A=require("workflow-designer/status-lozenge-colours");var B=require("workflow-designer/status-model");var I=require("workflow-designer/status-view");var E=require("workflow-designer/workflow-model");var F=require("workflow-designer/test-utilities");var H=require("workflow-designer/underscore");var G=require("workflow-designer/draw-2d");var C=require("workflow-designer/io/ajax/workflow-statuses-ajax-manager");module("StatusView",{allPortsAreVisible:function(J){return H.all(J.getPorts(),function(K){return K.isVisible()})},createStatusView:function(L){var K=H.bind(this.canvasView._getAllTargetPorts,this.canvasView),M=H.bind(this.canvasView._isPortDragged,this.canvasView),J;L=H.defaults({},L,{canvas:this.canvas,model:new B(),getAllTargetPorts:K,isPortDragged:M,workflowModel:this.workflowModel});J=new I(L).render();this.canvasView.statusViews.add(J);return J},noPortsAreVisible:function(J){return H.all(J.getPorts(),function(K){return !K.isVisible()})},setup:function(){this.canvasView=F.testCanvasView();this.canvas=this.canvasView.canvas;this.sandbox=sinon.sandbox.create();this.workflowModel=new E();this.validateRemoveStatusResponse=jQuery.Deferred();this.validateRemoveStatusStub=this.sandbox.stub(C,"validateRemoveStatus");this.validateRemoveStatusStub.returns(this.validateRemoveStatusResponse)},teardown:function(){F.removeDialogs();this.sandbox.restore()}});test("All ports are visible while dragging",function(){var L,K,J;L=this.createStatusView();ok(this.noPortsAreVisible(L),"Ports aren't visible initially");J=this.createStatusView();ok(this.noPortsAreVisible(J),"Ports aren't visible initially");K=J.getPorts()[0];K.onDragStart();ok(this.allPortsAreVisible(L),"All ports are visible on the target status");ok(H.all(H.tail(J.getPorts()),function(M){return M.isVisible()}),"All ports are visible on the source status except the one being dragged");K.onDragEnd();ok(this.noPortsAreVisible(L),"No ports are visible on the target status");ok(this.allPortsAreVisible(J),"All ports are visible on the source status")});test("destroy() shows a DeleteStatusDialogView when validation succeeded",function(){var L,K=this.sandbox.stub(D.prototype,"initialize").returns(jQuery.noop),J=this.createStatusView();this.sandbox.stub(D.prototype,"show").returns(jQuery.noop);J.destroy();equal(K.callCount,0,"A DeleteStatusDialogView should be not yet created");this.validateRemoveStatusResponse.resolve();equal(K.callCount,1,"A DeleteStatusDialogView was created");L=K.args[0];equal(L.length,1,"It was passed a single argument");equal(L[0].errorMessage,undefined,"It was passed without errorMessage");equal(L[0].statusModel,J.model,"It was passed the correct StatusModel");equal(L[0].workflowModel,this.workflowModel,"It was passed the correct WorkflowModel")});test("destroy() shows a DeleteStatusDialogView with error when validation fails",function(){var L="Example of error message";var M,K=this.sandbox.stub(D.prototype,"initialize").returns(jQuery.noop),J=this.createStatusView();this.sandbox.stub(D.prototype,"show").returns(jQuery.noop);J.destroy();equal(K.callCount,0,"A DeleteStatusDialogView should be not yet created");this.validateRemoveStatusResponse.reject(L);equal(K.callCount,1,"A DeleteStatusDialogView was created");M=K.args[0];equal(M.length,1,"It was passed a single argument");equal(M[0].errorMessage,L,"It was passed with the correct errorMessage");equal(M[0].statusModel,J.model,"It was passed the correct StatusModel");equal(M[0].workflowModel,this.workflowModel,"It was passed the correct WorkflowModel")});test("Double clicking a status doesn't initiate editing when immutable",function(){var K=this.sandbox.stub(I.prototype,"edit"),J=this.createStatusView({immutable:true});J._figure.onDoubleClick();equal(K.callCount,0,"StatusView#edit() wasn't called")});test("Double clicking a status initiates editing",function(){this.workflowModel.get("permissions").set("editStatus",true);var K=this.sandbox.stub(I.prototype,"edit"),J=this.createStatusView();J._figure.onDoubleClick();equal(K.callCount,1,"StatusView#edit() was called.")});test("Drag events are triggered",function(){var K;function J(L){var M=sinon.spy(),N=sinon.spy();L.bind("drag",N);L.bind("dragEnd",M);L._figure.onDrag();equal(N.callCount,1,"A drag event was triggered");L._figure.command=L._figure.createCommand(new G.command.CommandType(G.command.CommandType.MOVE));L._figure.onDragEnd();equal(M.callCount,1,"A dragEnd event was triggered")}K=[this.createStatusView(),this.createStatusView({immutable:true})];H.each(K,J)});test("Dragging a port selects the associated status",function(){var J=this.createStatusView();ok(!J.isSelected(),"The status isn't selected");J.getPorts()[0].onDragStart();ok(J.isSelected(),"The status is selected")});test("Dragging the view updates model coordinates",function(){var J;J=this.createStatusView();J.getBoundingBox=function(){return new G.geo.Rectangle(100,200,10,10)};J._figure.onDragStart();J._figure.onDragEnd();equal(J.model.get("x"),100,"The model's x coordinate was updated");equal(J.model.get("y"),200,"The model's y coordinate was updated")});test("Highlight events are triggered on hover",function(){var K;function J(L){var M=sinon.spy(),N=sinon.spy();L.bind("highlight",M);L.bind("unhighlight",N);L._figure.onMouseEnter();equal(M.callCount,1,"A highlight event was fired");L._figure.onMouseLeave();equal(N.callCount,1,"An unhighlight event was fired")}K=[this.createStatusView(),this.createStatusView({immutable:true})];H.each(K,J)});test("Statuses are the correct colour when status lozenges are available",function(){var K,J;this.sandbox.stub(A,"getBackgroundColour").returns("#ff0000");this.sandbox.spy(A,"getBorderColour");this.sandbox.stub(A,"getColour").returns("#00ff00");J=this.createStatusView({model:new B({statusCategory:{colourName:"green",id:1}})});K=[{colourName:"green",isSubtle:false}];equal(A.getBackgroundColour.callCount,1,"StatusLozengeColours.getBackgroundColour was called");deepEqual(A.getBackgroundColour.args[0],K,"It was passed the correct arguments");equal(A.getBorderColour.callCount,0,"StatusLozengeColours.getBorderColour wasn't called");equal(A.getColour.callCount,1,"StatusLozengeColours.getColour was called");deepEqual(A.getColour.args[0],K,"It was passed the correct arguments");equal(J._figure.getBackgroundColor().hash(),"#FF0000","The status has the correct background colour");equal(J._figure.getColor().hash(),"#FFFFFF","The status has the correct border colour");equal(J._figure.getTextColor().hash(),"#00FF00","The status has the correct text colour")});test("Statuses are the correct colour when status lozenges aren't available",function(){var J=this.createStatusView();equal(J._figure.getBackgroundColor().hash(),"#4A6785","The status has the correct background colour");equal(J._figure.getColor().hash(),"#FFFFFF","The status has the correct border colour");equal(J._figure.getTextColor().hash(),"#FFFFFF","The status has the correct text colour")});test("Ports are shown on hover",function(){var J=this.createStatusView();ok(this.noPortsAreVisible(J),"Ports aren't visible initially");J._figure.onMouseEnter();ok(this.allPortsAreVisible(J),"Ports become visible on hover");J._figure.onMouseLeave();ok(this.noPortsAreVisible(J),"Ports are hidden on mouse leave")});test("Ports are shown on port hover",function(){var K,J;J=this.createStatusView();K=J.getPorts()[0];ok(this.noPortsAreVisible(J),"Ports aren't visible initially");K.onMouseEnter();ok(this.allPortsAreVisible(J),"Ports become visible on port hover");K.onMouseLeave();ok(this.noPortsAreVisible(J),"Ports are hidden on mouse leave")});test("Ports aren't hidden after moving from the status body to a port",function(){var K,J;J=this.createStatusView();K=J.getPorts()[0];ok(this.noPortsAreVisible(J),"Ports aren't visible initially");J._figure.onMouseEnter();ok(this.allPortsAreVisible(J),"Ports become visible on hover");J._figure.onMouseLeave(K);ok(this.allPortsAreVisible(J),"Ports are still visible as the new figure is a port");K.onMouseLeave(J._figure);ok(this.allPortsAreVisible(J),"Ports are still visible as the new figure is the status")});test("Ports aren't shown on hover when immutable",function(){var J=this.createStatusView({immutable:true});ok(this.noPortsAreVisible(J),"Ports aren't visible initially");J._figure.onMouseEnter();ok(this.noPortsAreVisible(J),"Ports aren't visible on hover")});test("Statuses are the correct colour when status lozenges are available in subtle mode",function(){var J,L,K;this.sandbox.stub(A,"getBackgroundColour").returns("#ff0000");this.sandbox.stub(A,"getBorderColour").returns("#00ff00");this.sandbox.stub(A,"getColour").returns("#0000ff");this.canvasView=F.testCanvasView({workflowModel:new E({currentStepId:1})});J=this.canvasView.addStatus(new B({statusCategory:{colourName:"green",id:1},stepId:1}));L=[{colourName:"green",isSubtle:false}];equal(A.getBackgroundColour.callCount,1,"StatusLozengeColours.getBackgroundColour was called");deepEqual(A.getBackgroundColour.args[0],L,"It was passed the correct arguments");equal(A.getBorderColour.callCount,0,"StatusLozengeColours.getBorderColour wasn't called");equal(A.getColour.callCount,1,"StatusLozengeColours.getColour was called");deepEqual(A.getColour.args[0],L,"It was passed the correct arguments");equal(J._figure.getBackgroundColor().hash(),"#FF0000","The current status has the correct background colour");equal(J._figure.getColor().hash(),"#FFFFFF","The current status has the correct border colour");equal(J._figure.getTextColor().hash(),"#0000FF","The current status has the correct text colour");K=this.canvasView.addStatus(new B({statusCategory:{colourName:"yellow",id:2},stepId:2}));L=[{colourName:"yellow",isSubtle:true}];equal(A.getBackgroundColour.callCount,2,"StatusLozengeColours.getBackgroundColour was called");deepEqual(A.getBackgroundColour.args[1],L,"It was passed the correct arguments");equal(A.getBorderColour.callCount,1,"StatusLozengeColours.getBorderColour was called");deepEqual(A.getBorderColour.args[0],L,"It was passed the correct arguments");equal(A.getColour.callCount,2,"StatusLozengeColours.getColour was called");deepEqual(A.getColour.args[1],L,"It was passed the correct arguments");equal(K._figure.getBackgroundColor().hash(),"#FF0000","The current status has the correct background colour");equal(K._figure.getColor().hash(),"#00FF00","The current status has the correct border colour");equal(K._figure.getTextColor().hash(),"#0000FF","The current status has the correct text colour")});test("Statuses are the correct colour when status lozenges aren't available in subtle mode",function(){var J,K;this.canvasView=F.testCanvasView({workflowModel:new E({currentStepId:1})});J=this.canvasView.addStatus(new B({stepId:1}));equal(J._figure.getBackgroundColor().hash(),"#4A6785","The current status has the correct background colour");equal(J._figure.getColor().hash(),"#FFFFFF","The current status has the correct border colour");equal(J._figure.getTextColor().hash(),"#FFFFFF","The current status has the correct text colour");K=this.canvasView.addStatus(new B({stepId:2}));equal(K._figure.getBackgroundColor().hash(),"#FFFFFF","The other status has the correct background colour");equal(K._figure.getColor().hash(),"#4A6785","The other status has the correct border colour");equal(K._figure.getTextColor().hash(),"#4A6785","The other status has the correct text colour")});test('The figure is added to the "selected-status" layer on selection',function(){var L=this.canvas.getLayer("selected-status"),K=this.canvas.getLayer("statuses"),J=this.createStatusView();sinon.spy(L,"addFigure");sinon.spy(K,"addFigure");J.select();equal(L.addFigure.callCount,1,'The "selected-status" layer\'s #addFigure() method was called');ok(L.addFigure.args[0][0]===J._figure,"It was passed the correct figure");J.deselect();equal(K.addFigure.callCount,1,'The "statuses" layer\'s #addFigure() method was called');ok(K.addFigure.args[0][0]===J._figure,"It was passed the correct figure")});test('The figure is added to the "statuses" layer',function(){var K=this.canvas.getLayer("statuses"),J;sinon.spy(K,"addFigure");J=this.createStatusView();equal(K.addFigure.callCount,1,'The "statuses" layer\'s #addFigure() method was called');ok(K.addFigure.args[0][0]===J._figure,"It was passed the correct figure")})});