AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var M;var O;var G;var D;var F;var E;var J;var B;var N;var I;var L;var H;var A;var C=require("aui/tabs");var K;module("AddTransitionDialogView",{createWorkflowModel:function(Q){var P;P=new F({permissions:new E({editPropertyOptions:true,selectScreenOnTransition:true})});P.get("statuses").add([{name:"Open",stepId:1},{name:"In Progress",stepId:2},{name:"Closed",stepId:3}]);if(Q){P.set("permissions",Q)}return P},setup:function(){this.sandbox=sinon.sandbox.create();this.context=AJS.test.mockableModuleContext();this.context.mock("workflow-designer/analytics",require("workflow-designer/analytics"));this.newTransitionFormViewSpy=this.sandbox.spy(require("workflow-designer/new-transition-form-view"));this.context.mock("workflow-designer/new-transition-form-view",this.newTransitionFormViewSpy);this.reuseTransitionFormViewSpy=this.sandbox.spy(require("workflow-designer/reuse-transition-form-view"));this.context.mock("workflow-designer/reuse-transition-form-view",this.reuseTransitionFormViewSpy);this.context.mock("workflow-designer/dialogs/form-dialog-view",require("workflow-designer/dialogs/form-dialog-view"));this.context.mock("workflow-designer/io/ajax/screens-ajax-manager",require("workflow-designer/io/ajax/screens-ajax-manager"));this.context.mock("workflow-designer/transition-model",require("workflow-designer/transition-model"));this.context.mock("workflow-designer/messages",require("workflow-designer/messages"));this.context.mock("workflow-designer/test-utilities",require("workflow-designer/test-utilities"));I=this.context.require("workflow-designer/dialogs/form-dialog-view");N=this.context.require("workflow-designer/io/ajax/screens-ajax-manager");B=this.context.require("workflow-designer/transition-model");J=this.context.require("workflow-designer/canvas-model");F=this.context.require("workflow-designer/workflow-model");E=this.context.require("workflow-designer/permissions-model");D=this.context.require("workflow-designer/messages");G=this.context.require("workflow-designer/test-utilities");O=this.context.require("jquery");M=this.context.require("workflow-designer/underscore");K=this.context.require("workflow-designer/analytics");A=this.context.require("workflow-designer/new-transition-form-view");H=this.context.require("workflow-designer/reuse-transition-form-view");L=this.context.require("workflow-designer/dialogs/add-transition-dialog-view");this.getScreensDeferred=O.Deferred().resolve([]);this.getScreensStub=this.sandbox.stub(N,"getScreens").returns(this.getScreensDeferred);this.newTransitionFormViewSubmitDeferred=O.Deferred();this.newTransitionFormViewSubmitStub=this.sandbox.stub(A.prototype,"submit").returns(this.newTransitionFormViewSubmitDeferred);this.reuseTransitionFormViewSubmitDeferred=O.Deferred();this.reuseTransitionFormViewSubmitStub=this.sandbox.stub(H.prototype,"submit").returns(this.reuseTransitionFormViewSubmitDeferred);this.showErrorMessageSpy=this.sandbox.spy(L.prototype,"showErrorMessage");this.workflowModel=this.createWorkflowModel()},showDialog:function(P){P=M.defaults({},P,{transitionModel:new B(),workflowModel:this.workflowModel});P.canvasModel||(P.canvasModel=new J({},{workflowModel:P.workflowModel}));return new L(P).show()},teardown:function(){G.removeDialogs();this.sandbox.restore()}});test("Automatically selects the transition's source and target statuses",function(){var R,P,S,Q;Q=this.createWorkflowModel();S=Q.get("statuses");this.showDialog({transitionModel:new B({source:S.at(1),target:S.at(2)})});R=this.newTransitionFormViewSpy.thisValues[0];equal(R.ui.sourceStepId.val(),2,"The transition's source is selected");equal(R.ui.targetStepId.val(),3,"The transition's target is selected");P=this.reuseTransitionFormViewSpy.thisValues[0];equal(P.ui.sourceStepId.val(),2,"The transition's source is selected");equal(P.ui.targetStepId.val(),3,"The transition's target is selected")});test("Creates and shows a NewTransitionFormView and a ReuseTransitionFormView",function(){var R=this.showDialog(),Q,P,S;S=[{selected:false,text:"Closed",value:3},{selected:false,text:"In Progress",value:2},{selected:false,text:"Open",value:1}];Q={model:R.options.transitionModel,screens:[],sourceStatuses:S,targetStatuses:S,workflowModel:R.options.workflowModel};ok(this.newTransitionFormViewSpy.calledWithExactly(Q),"A NewTransitionFormView was created");ok(R.newTransitionPane.currentView===this.newTransitionFormViewSpy.thisValues[0],"It was shown in the newTransitionPane region");P=M.omit(Q,"screens","screensPermission");ok(this.reuseTransitionFormViewSpy.calledWithExactly(P),"A ReuseTransitionFormView was created");ok(R.reuseTransitionPane.currentView===this.reuseTransitionFormViewSpy.thisValues[0],"It was shown in the reuseTransitionPane region")});test("Doesn't show the initial status in the status fields",function(){var P;P=this.createWorkflowModel();P.get("statuses").reset([{initial:true}]);this.showDialog({workflowModel:P});deepEqual(this.newTransitionFormViewSpy.args[0][0].sourceStatuses,[],"No source statuses were passed to NewTransitionFormView");deepEqual(this.newTransitionFormViewSpy.args[0][0].targetStatuses,[],"No target statuses were passed to NewTransitionFormView");deepEqual(this.reuseTransitionFormViewSpy.args[0][0].sourceStatuses,[],"No source statuses were passed to ReuseTransitionFormView");deepEqual(this.reuseTransitionFormViewSpy.args[0][0].targetStatuses,[],"No target statuses were passed to ReuseTransitionFormView")});test("Failing to create a new transition",function(){var P;P=this.showDialog();P.$("form").submit();this.newTransitionFormViewSubmitDeferred.reject("Nope");equal(P.$(":input:disabled").length,0,"All inputs are enabled");ok(this.showErrorMessageSpy.calledWithExactly("Nope"),"The correct error message was shown")});test("Failing to reuse a transition",function(){var P;P=this.showDialog();C.change(P.$(".aui-tabs a:last"));P.$("form").submit();this.reuseTransitionFormViewSubmitDeferred.reject("Nope");equal(P.$(":input:disabled").length,0,"All inputs are enabled");ok(this.showErrorMessageSpy.calledWithExactly("Nope"),"The correct error message was shown")});test("Hides and shows an error message when loading screen information fails",function(){var Q,R,P;R=O.Deferred();P=this.sandbox.stub(D,"showErrorMessage");this.getScreensStub.returns(R);Q=this.showDialog();R.reject("Error");ok(Q.$el.is(":hidden"),"The dialog isn't visible");ok(P.calledWithExactly("Error"),"showErrorMessage was called with the correct error message")});test("Repositions on tab change",function(){var Q,P;Q=this.showDialog();P=this.sandbox.spy(I.prototype,"reposition");Q.$(".aui-tabs a:last").click();equal(P.callCount,1,"FormDialogView#reposition was called")});test("Requests screen information on show",function(){var P,Q;Q=O.Deferred();this.getScreensStub.returns(Q);P=this.showDialog();ok(P.$el.is(":hidden"),"The dialog isn't visible");Q.resolve([]);ok(P.$el.is(":visible"),"The dialog is visible")});test("Shows the new transition pane when ReuseTransitionFormView triggers a createNewTransition event",function(){var R,Q,P,S;R=this.showDialog();Q=R.$(".aui-tabs .new-transition > a");S=this.sandbox.spy(C,"change");P=this.reuseTransitionFormViewSpy.thisValues[0];P.trigger("createNewTransition");ok(S.calledWithExactly(Q),"The new transition pane was shown")});test("Successfully creates a new transition",function(){this.sandbox.stub(K,"triggerAddTransition");this.sandbox.stub(K,"triggerFirstAddTransition");var Q=this.showDialog(),P=Q.options.transitionModel;Q.$("form").submit();equal(Q.$(":input:disabled").length,Q.$(":input").length,"All inputs are disabled");equal(this.newTransitionFormViewSubmitStub.callCount,1,"NewTransitionFormView#submit was called");this.newTransitionFormViewSubmitDeferred.resolve();ok(Q.options.canvasModel.get("selectedModel")===P,"The TransitionModel is selected");ok(Q.options.workflowModel.get("transitions").contains(P),"The TransitionModel was added to the WorkflowModel's transitions collection");ok(!G.dialogIsVisible(),"The dialog was hidden");ok(K.triggerAddTransition.calledOnce,"Analytics event for add/transition has been triggered");sinon.assert.calledWith(K.triggerAddTransition,this.workflowModel.get("permissions"));ok(K.triggerFirstAddTransition.calledOnce,"Analytics event for add/transition has been triggered");equal(K.triggerFirstAddTransition.getCall(0).args[1],this.workflowModel.get("permissions"))});test("Successfully reuses an existing transition",function(){var Q=this.showDialog(),P=Q.options.transitionModel;C.change(Q.$(".aui-tabs a:last"));Q.$("form").submit();equal(Q.$(":input:disabled").length,Q.$(":input").length,"All inputs are disabled");equal(this.reuseTransitionFormViewSubmitStub.callCount,1,"ReuseTransitionFormView#submit was called");this.reuseTransitionFormViewSubmitDeferred.resolve();ok(Q.options.canvasModel.get("selectedModel")===P,"The TransitionModel is selected");ok(Q.options.workflowModel.get("transitions").contains(P),"The TransitionModel was added to the WorkflowModel's transitions collection");ok(!G.dialogIsVisible(),"The dialog was hidden")});test("When doesn't have screen permissions no rest call is made to screens",function(){var P=this.createWorkflowModel();P.get("permissions").set({selectScreenOnTransition:false});this.showDialog({workflowModel:P});sinon.assert.notCalled(this.getScreensStub,"No rest call is made for screens")});test("When have screen permissions rest call is made to screens",function(){this.showDialog();sinon.assert.calledOnce(this.getScreensStub,"Rest call is made for screens")});test("When doesn't have screen permissions view should not contain screens select",function(){var Q=this.createWorkflowModel();Q.get("permissions").set({selectScreenOnTransition:false});var P=this.showDialog({workflowModel:Q});var R=O("#"+P.id);equal(R.find("#transition-screen-id").length,0,"No screen select should be present")});test("When have screen permissions view should contain screens select",function(){var P=this.showDialog();var Q=O("#"+P.id);equal(Q.find("#transition-screen-id").length,1,"Screen select should be present")})});