AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var G=require("workflow-designer/io/ajax/status-categories-ajax-manager");var B=require("workflow-designer/io/ajax/workflow-statuses-ajax-manager");var E=require("workflow-designer/workflow-model");var A=require("workflow-designer/status-model");var D=require("workflow-designer/dialogs/create-status-dialog-view");var H=require("workflow-designer/analytics");var C=require("jira/dialog/dialog");var F=require("workflow-designer/test-utilities");var I=require("workflow-designer/underscore");var J=require("jquery");module("CreateStatusDialogView",{setup:function(){var L,K=this.sandbox=sinon.sandbox.create();L=J.Deferred().resolve([{colorName:"green",id:3,key:"done",name:"Complete"}]);this.createStatusStub=K.stub(B,"createStatus");this.createStatusStub.returns(J.Deferred().promise());this.getStatusCategoriesStub=K.stub(G,"getStatusCategories").returns(L);this.workflowModel=new E({name:"Workflow"})},showDialog:function(K){K=I.defaults({},K,{workflowModel:this.workflowModel,statusModel:new A()});new D(K).show();return C.current&&C.current.get$popup()},teardown:function(){F.removeDialogs();this.sandbox.restore()}});test("An error message appears if creation fails",function(){var M=this.showDialog(),K,L="No status for you!";this.createStatusStub.returns(J.Deferred().reject(L).promise());F.submit(M,{"#status-name":"Happy Little Status"});K=M.find(".aui-message.error");equal(K.length,1,"An error message is shown in the dialog");ok(K.text().indexOf(L)>-1,"It contains the correct text");equal(M.find(":disabled").length,0,"No inputs are disabled");this.createStatusStub.returns(J.Deferred().promise());F.submit(M);equal(M.find(".error").length,0,"Errors are removed on submit")});test("Creating a status without a global transition",function(){var L=J.Deferred(),N=this.showDialog(),K,M=this.sandbox.stub(this.workflowModel,"reset");this.createStatusStub.returns(L);this.sandbox.stub(H,"triggerAddStatus");this.sandbox.stub(H,"triggerAddStep");this.sandbox.stub(H,"triggerFirstAddStatus");F.submit(N,{"#status-description":"This is a status description. How exciting.","#status-name":"Happy Little Status"});K={createGlobalTransition:false,description:"This is a status description. How exciting.",name:"Happy Little Status",statusCategoryId:"3",workflowName:this.workflowModel.get("name")};equal(N.find(":input:disabled").length,N.find(":input").length,"All inputs are disabled while submitting");equal(this.createStatusStub.callCount,1,"StatusesAJAXManager.createStatus() was called");deepEqual(this.createStatusStub.args[0],[K],"It was passed the correct options");L.resolve({});ok(!F.dialogIsVisible(),"The dialog closes on success");equal(M.callCount,1,"WorkflowModel.reset() was called");deepEqual(M.args[0],[{}],"It was passed the correct data");ok(H.triggerAddStatus.calledOnce,"Analytics event for add/status has been triggered");sinon.assert.calledWith(H.triggerAddStatus,this.workflowModel.get("permissions"));ok(H.triggerAddStep.calledOnce,"Analytics event for add/step has been triggered");sinon.assert.calledWith(H.triggerAddStep,this.workflowModel.get("permissions"));ok(H.triggerFirstAddStatus.calledOnce,"Analytics event for add/step has been triggered");equal(H.triggerFirstAddStatus.getCall(0).args[1],this.workflowModel.get("permissions"))});test("The createGlobalTransition option is respected",function(){var K=this.showDialog({createGlobalTransition:true});equal(K.find("#create-global-transition-create").attr("checked"),"checked","The option was respected")});test('The "create global transition" checkbox is respected',function(){var K=this.showDialog(),L;this.createStatusStub.returns(J.Deferred().promise());K.find("#create-global-transition-create").attr("checked","checked");F.submit(K,{"#status-description":"This is a status description. How exciting.","#status-name":"Happy Little Status"});L=[{createGlobalTransition:true,description:"This is a status description. How exciting.",name:"Happy Little Status",statusCategoryId:"3",workflowName:this.workflowModel.get("name")}];equal(this.createStatusStub.callCount,1,"WorkflowStatusesAJAXManager.createStatus() was called");deepEqual(this.createStatusStub.args[0],L,"It was passed the correct arguments")})});