AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var C;var F=require("jira/ajs/contentretriever/content-retriever");var B=require("workflow-designer/io/ajax/workflow-statuses-ajax-manager");var D=require("workflow-designer/workflow-model");var E=require("workflow-designer/test-utilities");var A=require("workflow-designer/messages");var G=require("workflow-designer/analytics");var I=require("jira/ajs/list/item-descriptor");var H=require("workflow-designer/underscore");var J=require("jquery");module("AddStatusInlineDialogView",{assertOption:function(K,M,L){K=J(K);equal(K.text(),M,"The option contains the correct text");equal(K.val(),L,"The option contains the correct value")},checkCreateGlobalTransition:function(K){K.ui.createGlobalTransition.attr("checked","");K.ui.createGlobalTransition.change()},mockStatusView:function(){this.context.mock("jira/ajs/contentretriever/content-retriever",F);this.context.mock("workflow-designer/io/ajax/workflow-statuses-ajax-manager",B);C=this.context.require("workflow-designer/dialogs/add-status-inline-dialog-view")},createDialog:function(K){K=H.defaults({},K,{trigger:J("<div>"),workflowModel:this.workflowModel});return new C(K)},createWorkflowModel:function(L){var K=new D();K.get("permissions").set("createStatus",H.isUndefined(L)?true:L);return K},selectStatus:function(L,M,K){L.ui.statusName.trigger("selected",new I({fieldText:K,label:K,value:M}))},setup:function(){var L=J.Deferred(),K=this.sandbox=sinon.sandbox.create();this.context=AJS.test.mockableModuleContext();C=require("workflow-designer/dialogs/add-status-inline-dialog-view");L.resolve([{id:"closed",name:"Closed"},{id:"open",name:"Open"}]);this.addStatusDeferred=J.Deferred();this.addStatusStub=K.stub(B,"addStatus").returns(this.addStatusDeferred);this.getStatusesStub=K.stub(B,"getStatuses").returns(L);this.workflowModel=this.createWorkflowModel()},teardown:function(){E.removeDialogs();this.sandbox.restore()}});asyncTest("A CreateStatusDialogView is shown if the new status option was selected",function(){var L={show:sinon.spy()},O=this.sandbox.stub().returns(L),M,K=this,N=this.createWorkflowModel();this.context.mock("workflow-designer/dialogs/create-status-dialog-view",O);this.mockStatusView();M=this.createDialog({workflowModel:N});this.sandbox.spy(M,"_cancel");M.show().done(function(){K.selectStatus(M,"","New Status");M.$(":submit").click();equal(O.callCount,1,"A CreateStatusDialogView was created");equal(O.args[0][0].statusModel.get("name"),"New Status","It was passed a StatusModel with the correct name");ok(O.args[0][0].workflowModel===N,"It was passed the correct WorkflowModel");equal(L.show.callCount,1,"It was shown");equal(M._cancel.callCount,1,"The AddStatusInlineDialogView was hidden and reset");start()})});asyncTest("A CreateStatusDialogView is not shown if the new status option was selected",function(){var L={show:sinon.spy()},O=this.sandbox.stub().returns(L),M,K=this,N=this.createWorkflowModel();this.context.mock("workflow-designer/dialogs/create-status-dialog-view",O);this.mockStatusView();M=this.createDialog({workflowModel:N});this.sandbox.spy(M,"_cancel");M.show().done(function(){K.selectStatus(M,"","New Status");M.$(":submit").click();equal(O.callCount,1,"A CreateStatusDialogView was created");equal(O.args[0][0].statusModel.get("name"),"New Status","It was passed a StatusModel with the correct name");ok(O.args[0][0].workflowModel===N,"It was passed the correct WorkflowModel");equal(L.show.callCount,1,"It was shown");equal(M._cancel.callCount,1,"The AddStatusInlineDialogView was hidden and reset");start()})});asyncTest("An error message is shown if adding a status fails",function(){var M=this.createDialog(),L=sinon.spy(),K=this;M.on("done",L);M.show().done(function(){var O=J.Deferred(),N,P="No status for you!";M.$(":submit").click();K.addStatusDeferred.reject(P);N=M.$(".aui-message.error");equal(L.callCount,1,"A done event was triggered");equal(N.length,1,"An error message is shown in the inline dialog");equal(N.text(),P,"It contains the correct message");equal(M.$(":disabled").length,0,"No inputs are disabled");K.addStatusStub.returns(O);M.$(":submit").click();equal(M.$(".aui-message.error").length,0,"Error messages are removed while submitting");O.resolve({});start()})});test("An error message is shown if statuses fail to load",function(){var M=this.createDialog(),K="No statuses for you!",L=this.sandbox.stub(A,"showErrorMessage");this.getStatusesStub.returns(J.Deferred().reject(K));M.show();equal(L.callCount,1,"An error message was shown");equal(L.args[0][0],K,"The correct error message was shown")});asyncTest("Clicking a status name suggestion doesn't close the dialog",function(){var K=this.createDialog();this.sandbox.spy(K,"hide");K.show().done(function(){K._statusName._handleCharacterInput(true);K._statusName.dropdownController.layer().click();equal(K.hide.callCount,0,"The dialog wasn't hidden");start()})});asyncTest("Clicking cancel closes and resets the dialog",function(){var L=this.createDialog(),K=this;this.sandbox.spy(L,"hide");L.show().done(function(){K.checkCreateGlobalTransition(L);K.selectStatus(L,"open","Open");L.$(".cancel").click();equal(L.hide.callCount,1,"The dialog was hidden");L.show().done(function(){equal(L.$(":selected").val(),"closed","The selected status was cleared");ok(!L.ui.createGlobalTransition.is(":checked"),"The create global transition checkbox was unchecked");start()})})});asyncTest("Clicking the document doesn't close the dialog while it's submitting",function(){var L=this.createDialog(),K=this,M=L._inlineDialog.getOptions().preHideCallback;L.show().done(function(){ok(M(),"The inline dialog will close before submission");L.$(":submit").click();ok(!M(),"The inline dialog won't close while submitting");K.addStatusDeferred.resolve({});start()})});asyncTest("No error appears if the message is empty",function(){var K=this.createDialog();this.addStatusDeferred.reject();K.show().done(function(){K.ui.submit.click();equal(K.$(".aui-message.error").length,0,"No error message appeared");start()})});asyncTest("Submission is ignored if no status is selected",function(){var M=this.sandbox.spy();this.context.mock("workflow-designer/dialogs/create-status-dialog-view",M);this.mockStatusView();var L=this.createDialog(),K=this;this.getStatusesStub.returns(J.Deferred().resolve([]));L.show().done(function(){L.ui.form.submit();equal(M.callCount,0,"No CreateStatusDialogView was created");equal(K.addStatusStub.callCount,0,"WorkflowStatusesAJAXManager.addStatus wasn't called");start()})});asyncTest("Submitting the form adds a status to the workflow",function(){var N,M=sinon.spy(),P,K=this,Q={},R=this.sandbox.spy(B,"reset"),L=sinon.spy(),O;O=new D({name:"Workflow"});this.sandbox.stub(O,"reset");N=this.createDialog({workflowModel:O});N.on({done:M,submit:L});this.sandbox.spy(N,"hide");P=[{createGlobalTransition:false,statusId:"closed",workflowName:"Workflow"}];N.show().done(function(){var S;N.$(":submit").click();S=N.$(":input:visible");equal(S.filter(":disabled").length,S.length,"All inputs are disabled");equal(K.addStatusStub.callCount,1,"WorkflowStatusesAJAXManager.addStatus was called");deepEqual(K.addStatusStub.args[0],P,"It was passed the correct options");equal(L.callCount,1,"A submit event was triggered");K.addStatusDeferred.resolve(Q);equal(N.hide.callCount,1,"The dialog was hidden");equal(M.callCount,1,"A done event was triggered");equal(O.reset.callCount,1,"The WorkflowModel was reset");ok(O.reset.args[0][0]===Q,"It was passed the correct layout data");equal(R.callCount,1,"WorkflowStatusesAJAXManager was reset");start()})});asyncTest('The "create global transition" checkbox is respected',function(){var L,N,K=this,M=new D({name:"Workflow"});L=this.createDialog({workflowModel:M});N=[{createGlobalTransition:true,statusId:"closed",workflowName:"Workflow"}];L.show().done(function(){L.ui.createGlobalTransition.attr("checked","");L.ui.submit.click();equal(K.addStatusStub.callCount,1,"WorkflowStatusesAJAXManager.addStatus was called");deepEqual(K.addStatusStub.args[0],N,"It was passed the correct options");K.addStatusDeferred.resolve({});start()})});asyncTest('The "create global transition" checkbox state is passed to the create status dialog',function(){var L=this.sandbox.spy(require("workflow-designer/dialogs/create-status-dialog-view"));this.context.mock("workflow-designer/dialogs/create-status-dialog-view",L);this.mockStatusView();var M=this.createDialog(),K=this;M.show().done(function(){K.selectStatus(M,"","New Status");M.ui.createGlobalTransition.attr("checked","");M.ui.submit.click();equal(L.callCount,1,"A CreateStatusDialogView was created");ok(L.args[0][0].createGlobalTransition,"It was passed the state of the create global transition checkbox");start()})});asyncTest('The "create global transition" checkbox state is persisted between shows',function(){var L=this.createDialog(),K=this;L.show().done(function(){K.checkCreateGlobalTransition(L);L.hide();L.show().done(function(){ok(L.ui.createGlobalTransition.is(":checked"),"The state was persisted");start()})})});asyncTest("The dialog appears after its content fails to load",function(){var K=this.createDialog(),L=this.getStatusesStub;L.returns(J.Deferred().reject());K.show().done(function(){ok(!K.$el.is(":visible"),"The dialog isn't visible");L.returns(J.Deferred().resolve([]));K.show().done(function(){ok(K.$el.is(":visible"),"The dialog is visible");start()})})});asyncTest("The dialog is reset after submission",function(){var L=this.createDialog(),K=this;L.show().done(function(){K.checkCreateGlobalTransition(L);K.selectStatus(L,"open","Open");L.ui.submit.click();K.addStatusDeferred.resolve({});L.show().done(function(){equal(L.$(":selected").val(),"closed","The selected status was cleared");ok(!L.ui.createGlobalTransition.is(":checked"),"The create global transition checkbox was unchecked");start()})})});asyncTest("The selected new status is persisted across shows",function(){var L=this.createDialog(),K=this;L.show().done(function(){K.selectStatus(L,"","New Status");L.hide();L.show().done(function(){K.assertOption(L.$(":selected"),"New Status","");start()})})});asyncTest("The selected status is persisted across shows",function(){var L=this.createDialog(),K=this;L.show().done(function(){K.selectStatus(L,"open","Open");L.hide();L.show().done(function(){equal(L.$(":selected").val(),"open","The selected status was persisted");start()})})});asyncTest("The submit button is initially disabled if no existing statuses are available",function(){var L,K=this;this.getStatusesStub.returns(J.Deferred().resolve([]));L=this.createDialog();L.show().done(function(){equal(L.$(":disabled:submit").length,1,"The submit button is disabled initially");K.selectStatus(L,"","New Status");equal(L.$(":disabled:submit").length,0,"The submit button is enabled after selecting a new status");L.ui.statusName.trigger("unselect");equal(L.$(":disabled:submit").length,1,"The submit button is disabled after clearing the selection");start()})});asyncTest("Triggers analytics events after successfully adding an existing status",function(){var K=this.createDialog(),N=this.sandbox.spy(G,"triggerAddStep"),M=this.sandbox.spy(G,"triggerFirstAddStatus");var L=this.workflowModel;this.addStatusDeferred.resolve({});K.show().done(function(){K.$(":submit").click();equal(N.callCount,1,"An add step event was triggered");equal(M.callCount,1,"A first add status event was triggered");sinon.assert.calledWith(N,L.get("permissions"));equal(M.getCall(0).args[1],L.get("permissions"));start()})});asyncTest("Valid statuses are listed in the dialog",function(){var N,M=J.Deferred(),K=this,L,P,O;this.getStatusesStub.returns(M);O=new D();O.addStatus({statusId:"in-progress"});O.set({name:"workflow name"});N=this.createDialog({workflowModel:O});P=N.show();equal(this.getStatusesStub.callCount,1,"WorkflowStatusesAJAXManager.getStatuses was called");ok(this.getStatusesStub.calledWith({workflowName:"workflow name"}),"WorkflowStatusesAJAXManager.getStatuses was called with workflowName: 'workflow name'");M.resolve([{id:"in-progress",name:"In Progress"},{id:"open",name:"Open"},{id:"closed",name:"Closed"}]);P.done(function(){L=N.$("#status-name option");equal(L.length,2,"The correct number of options are present");K.assertOption(L[0],"Closed","closed");K.assertOption(L[1],"Open","open");start()})});asyncTest("Valid info message is presented to user that can create new status",function(){var K=this.createDialog();this.addStatusDeferred.reject();K.show().done(function(){ok(K.$el.html().indexOf("workflow.designer.add.status.description")>=0,"Dialog should contain workflow.designer.add.status.description");start()})});asyncTest("Valid info message is presented to user that can NOT create new status",function(){var L=this.createWorkflowModel(false);var K=this.createDialog({workflowModel:L});this.addStatusDeferred.reject();K.show().done(function(){ok(K.$el.html().indexOf("workflow.designer.add.existing.status.description")>=0,"Dialog should contain workflow.designer.add.existing.status.description");start()})})});