AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:form-dialog-view",
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var FormDialogView = require("workflow-designer/dialogs/form-dialog-view");
    var TestUtilities = require("workflow-designer/test-utilities");
    var jQuery = require("jquery");

    module("FormDialogView", {
        /**
         * @returns {FormDialogView} A `FormDialogView`.
         */
        createDialog: function () {
            var View;

            View = FormDialogView.extend({
                _getContent: function () {
                    return jQuery("<div>").addClass("form-body");
                }
            });

            return new View();
        },

        teardown: function () {
            TestUtilities.removeDialogs();
        }
    });

    test("showErrorMessage() does nothing if the message is empty", function () {
        var dialog;

        dialog = this.createDialog();
        dialog.show();

        _.each([null, undefined, ""], function (message) {
            dialog.showErrorMessage(message);
            equal(dialog.$(".aui-message.error").length, 0, "No error message is visible");
        });
    });

});
