define("workflow-designer/dialogs/edit-transition-target-dialog-view", [
    "workflow-designer/dialogs/form-dialog-view",
    "workflow-designer/io/ajax/workflow-transitions-ajax-manager",
    "workflow-designer/templates",
    "workflow-designer/backbone",
    "workflow-designer/underscore",
    "jquery"
], function(
    FormDialogView,
    WorkflowTransitionsAJAXManager,
    Templates,
    Backbone,
    _,
    jQuery
) {
    return FormDialogView.extend(
    /** @lends JIRA.WorkflowDesigner.Dialogs.EditTransitionTargetDialogView# */
    {
        /**
         * DOM id used for the main element of this view
         *
         * @type {string}
         * @default
         */
        id: "edit-transition-target-dialog",

        /**
         * Initialise the view.
         *
         * @constructs
         * @classdesc The workflow designer's "Edit transition target" dialog.
         * @extends JIRA.WorkflowDesigner.Dialogs.FormDialogView
         * @param {object} options
         * @param {JIRA.WorkflowDesigner.TransitionView} options.transitionView The transition view.
         * @param {JIRA.WorkflowDesigner.StatusPort} options.targetPort The new target port.
         * @param {JIRA.WorkflowDesigner.StatusView} options.targetView The new target status view.
         * @param {JIRA.WorkflowDesigner.WorkflowModel} options.workflowModel The workflow model.
         */
        initialize: function (options) {
            _.bindAll(this, "_onError", "_onSuccess");

            this._targetPort = options.targetPort;
            this._targetView = options.targetView;
            this._transitionView = options.transitionView;
            this._workflowModel = options.workflowModel;
        },

        /**
         * @returns {jQuery} Content of the dialog.
         * @private
         */
        _getContent: function () {
            return jQuery(Templates.confirmEditTransitionTargetDialog({
                targetStatusName: this._targetView.model.get("name"),
                transitionName: this._transitionView.model.get("name")
            }));
        },

        /**
         * Handler for cancel event.
         * @private
         */
        _onCancel: function () {
            this._transitionView.resetConnection();
        },

        /**
         * @param {jQuery.Event} e Submit event
         * @param {function} callback Function to call when this event has been handled
         * @private
         */
        _onSubmit: function (e, callback) {
            var request;

            e.preventDefault();
            this.disable();
            this.removeErrorMessages();

            request = WorkflowTransitionsAJAXManager.updateTransitionTarget({
                transitionId: this._transitionView.model.get("actionId"),
                targetStatusId: this._targetView.model.get("statusId"),
                workflowName: this._workflowModel.get("name")
            });

            request.done(this._onSuccess).fail(callback).fail(this._onError);
        },

        /**
         * @private
         */
        _onSuccess: function () {
            this.hide();

            this._workflowModel.updateTransitionTargets({
                targetAngle: this._targetView.getAngleToPort(this._targetPort),
                targetStepId: this._targetView.model.get("stepId"),
                transition: this._transitionView.model
            });
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.Dialogs.EditTransitionTargetDialogView", null, require("workflow-designer/dialogs/edit-transition-target-dialog-view"));