AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var L=require("jquery");var K=require("workflow-designer/io/ajax/statuses-ajax-manager");var G=require("workflow-designer/io/ajax/status-categories-ajax-manager");var C=require("workflow-designer/io/ajax/workflow-statuses-ajax-manager");var B=require("workflow-designer/status-model");var E=require("workflow-designer/workflow-model");var I=require("workflow-designer/dialogs/edit-status-dialog-view");var A=require("workflow-designer/messages");var H=require("workflow-designer/analytics");var D=require("jira/dialog/dialog");var F=require("workflow-designer/test-utilities");var J=require("workflow-designer/underscore");module("EditStatusDialogView",{setup:function(){var O,N,M=this.sandbox=sinon.sandbox.create();O=L.Deferred().resolve([{colorName:"blue-gray",id:2,key:"new",name:"New"},{colorName:"green",id:3,key:"done",name:"Complete"}]);N=L.Deferred().resolve([{id:100,numberOfWorkflows:1}]);this.getAssociatedWorkflowsStub=M.stub(K,"getNumberOfAssociatedWorkflows").returns(5);this.getStatusesStub=M.stub(K,"getStatuses").returns(N);this.getStatusCategoriesStub=M.stub(G,"getStatusCategories").returns(O);this.updateStatusStub=M.stub(C,"updateStatus").returns(L.Deferred());this.workflowModel=new E({name:"Workflow Name"})},showDialog:function(M){M=J.defaults({},M,{statusModel:new B({statusCategory:{id:3},statusId:100,stepId:1,name:"Status",description:"This is the description."}),workflowModel:this.workflowModel});new I(M).show();return D.current&&D.current.get$popup()},teardown:function(){F.removeDialogs();this.sandbox.restore()}});test("A warning is shown if the status is used in other workflows",function(){this.getStatusesStub.returns(L.Deferred().resolve([{id:100}]));equal(this.showDialog().find(".aui-message.warning").length,1,"A warning is shown")});test("An error message is shown if editing the status fails",function(){var O=this.showDialog(),M,N="Oh noes!";this.updateStatusStub.returns(L.Deferred().reject(N).promise());F.submit(O);M=O.find(".aui-message.error");equal(M.length,1,"An error message is shown in the dialog");ok(M.text().indexOf(N)>-1,"It contains the correct text");equal(O.find(":input:disabled").length,0,"No elements in the dialog are disabled");this.updateStatusStub.returns(L.Deferred().promise());F.submit(O);equal(O.find(".error").length,0,"Errors are removed on submit")});test("An error message is shown if loading associated workflows fails",function(){var M="No associated workflows for you!",N=this.sandbox.stub(A,"showErrorMessage");this.getAssociatedWorkflowsStub.returns(L.Deferred().reject(M));this.showDialog();ok(!F.dialogIsVisible(),"The dialog was hidden");ok(N.calledWithExactly(M),"An error message was shown")});test("An error message is shown if loading statuses fails",function(){var M="No statuses for you!",N=this.sandbox.stub(A,"showErrorMessage");this.getStatusesStub.returns(L.Deferred().reject(M));this.showDialog();ok(!F.dialogIsVisible(),"The dialog was hidden");ok(N.calledWithExactly(M),"An error message was shown")});test("Editing a status",function(){var N=L.Deferred(),P,O,Q,M,R=this.sandbox.spy(B.prototype,"initialize");P=this.showDialog();M=R.thisValues[0];this.updateStatusStub.returns(N.promise());this.sandbox.stub(H,"triggerUpdateStatus");this.sandbox.stub(H,"triggerUpdateStep");F.submit(P,{"#status-description":"Awesome new description!","#status-name":"New Name"});equal(P.find(":input:disabled").length,P.find(":input").length,"All inputs are disabled while submitting");equal(this.updateStatusStub.callCount,1,"WorkflowStatusesAJAXManager.updateStatus() was called");N.resolve();Q=[{description:"Awesome new description!",name:"New Name",statusCategoryId:"3",statusId:100,workflowName:"Workflow Name"}];O={description:"Awesome new description!",name:"New Name",statusCategory:{colourName:"green",id:3}};deepEqual(this.updateStatusStub.args[0],Q,"It was passed the correct arguments");deepEqual(J.pick(M.attributes,J.keys(O)),O,"The StatusModel's attributes were updated");ok(H.triggerUpdateStatus.calledOnce,"Analytics event for update/status has been triggered");sinon.assert.calledWith(H.triggerUpdateStatus,this.workflowModel.get("permissions"));ok(H.triggerUpdateStep.calledOnce,"Analytics event for udpate/step has been triggered");sinon.assert.calledWith(H.triggerUpdateStep,this.workflowModel.get("permissions"))});test("Fields are populated with the status's attributes",function(){var M=this.showDialog();equal(M.find("#status-description").val(),"This is the description.","The status's description was used");equal(M.find("#status-name").val(),"Status","The status's name was used")});test("No warning is shown if the status isn't used in other workflows",function(){this.getAssociatedWorkflowsStub.returns(L.Deferred().resolve(0));equal(this.showDialog().find(".aui-message.warning").length,0,"No warning is visible")});test("The selected status category is used",function(){var M,N=this.sandbox.spy(B.prototype,"initialize");this.updateStatusStub.returns(L.Deferred().resolve());F.submit(this.showDialog(),{"#status-category-id":"2"});equal(this.updateStatusStub.callCount,1,"WorkflowStatusesAJAXManager#updateStatus was called");equal(this.updateStatusStub.args[0][0].statusCategoryId,"2","It was passed the correct status category");M=N.thisValues[0];deepEqual(M.get("statusCategory"),{colourName:"blue-gray",id:2},"The StatusModel's statusCategory attribute was updated")})});