define("workflow-designer/dialogs/edit-global-transition-dialog-view", [
    "workflow-designer/dialogs/edit-transition-dialog-view",
    "workflow-designer/io/ajax/workflow-global-transitions-ajax-manager",
    "workflow-designer/analytics"
], function(
    EditTransitionDialogView,
    WorkflowGlobalTransitionsAJAXManager,
    Analytics
) {
    /**
     * @class JIRA.WorkflowDesigner.Dialogs.EditGlobalTransitionDialogView
     * @classdesc The workflow designer's "Edit Global Transition" dialog.
     * @extends JIRA.WorkflowDesigner.Dialogs.TransitionDialogView
     */
    return EditTransitionDialogView.extend(
    /** @lends JIRA.WorkflowDesigner.Dialogs.EditGlobalTransitionDialogView# */
    {
        id: "edit-global-transition-dialog",

        /**
         * Make a request to update the global transition.
         *
         * @return {jQuery.Deferred} A deferred that is resolved on success.
         * @private
         */
        _makeRequest: function (options) {
            return WorkflowGlobalTransitionsAJAXManager.updateGlobalTransition(options);
        },

        /**
         * Trigger an analytics event indicating that the update was successful.
         *
         * @protected
         */
        _triggerAnalyticsEvent: function () {
            Analytics.triggerUpdateGlobalTransition(this._workflowModel.get('permissions'), this._workflowModel.get("analyticsData"));
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.Dialogs.EditGlobalTransitionDialogView", null, require("workflow-designer/dialogs/edit-global-transition-dialog-view"));
