AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-read-only",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var WorkflowModel = require("workflow-designer/workflow-model");
    var CanvasModel = require("workflow-designer/canvas-model");
    var ZoomControlView = require("workflow-designer/zoom-control-view");
    var TestUtilities = require("workflow-designer/test-utilities");

    module("ZoomControlView", {
        setup: function () {
            this.canvasModel = new CanvasModel({}, {
                workflowModel: new WorkflowModel()
            });

            this.zoomControlView = new ZoomControlView({
                maximumZoomLevel: 2.0,
                minimumZoomLevel: 0.5,
                model: this.canvasModel
            }).render();
        }
    });

    test("Clicking the zoom in button triggers a \"zoomIn\" event", function () {
        var spy = sinon.spy();

        this.zoomControlView.on("zoomIn", spy);
        this.zoomControlView.$(".zoom-in").click();
        equal(spy.callCount, 1, "A zoomIn event was triggered");
    });

    test("Clicking the zoom out button triggers a \"zoomOut\" event", function () {
        var spy = sinon.spy();

        this.zoomControlView.on("zoomOut", spy);
        this.zoomControlView.$(".zoom-out").click();
        equal(spy.callCount, 1, "A zoomOut event was triggered");
    });

    test("The zoom in button is disabled at the maximum zoom level", function () {
        TestUtilities.fakeTimer(function (clock) {
            var zoomInButton;

            this.canvasModel.set("zoomLevel", 2.0);
            clock.tick(100);

            zoomInButton = this.zoomControlView.$(".zoom-in");
            equal(zoomInButton.attr("aria-disabled"), "true", "The zoom in button is disabled");
        }, this);
    });

    test("The zoom out button is disabled at the minimum zoom level", function () {
        TestUtilities.fakeTimer(function (clock) {
            var zoomOutButton;

            this.canvasModel.set("zoomLevel", 0.5);
            clock.tick(100);

            zoomOutButton = this.zoomControlView.$(".zoom-out");
            equal(zoomOutButton.attr("aria-disabled"), "true", "The zoom out button is disabled");
        }, this);
    });

});
