AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var D;var F=require("workflow-designer/workflow-model");var B=require("workflow-designer/canvas-model");var A=require("workflow-designer/test-utilities");var G=require("workflow-designer/backbone");var E=require("jquery");var C=require("workflow-designer/underscore");module("ActionsView",{createView:function(I){var H;var J=this.context.require("workflow-designer/internal-api/save-status-service");D=this.context.require("workflow-designer/actions-view");H=new D(C.extend({canvasModel:this.canvasModel,fullScreenButton:true,workflowModel:this.workflowModel,saveStatusService:new J()},I));this.container.empty().append(H.render().el);return H},setup:function(){this.sandbox=sinon.sandbox.create();this.context=AJS.test.mockableModuleContext();this.context.mock("jquery",E);this.context.mock("workflow-designer/status-model",require("workflow-designer/status-model"));var H=require("workflow-designer/last-saved-by/controller");this.sandbox.spy(H.prototype,"initialize");this.sandbox.spy(H.prototype,"show");this.sandbox.spy(H.prototype,"onClose");this.context.mock("workflow-designer/last-saved-by/controller",H);this.container=E("#qunit-fixture");this.workflowModel=new F();this.canvasModel=new B({},{workflowModel:this.workflowModel})},teardown:function(){A.removeDialogs();this.sandbox.restore()}});test("Add Status",function(){var H,J=C.extend({hide:sinon.stub(),show:sinon.stub()},G.Events),I=this.sandbox.stub().returns(J);this.context.mock("workflow-designer/dialogs/add-status-inline-dialog-view",I);this.createView();H=this.container.find(".add-status");H.click();equal(I.callCount,1,"An AddStatusInlineDialogView was created");ok(I.args[0][0].trigger[0]===this.container.find(".add-status")[0],"Its constructor was passed the correct arguments");equal(J.show.callCount,1,"The dialog was shown");H.addClass("active").click();equal(J.hide.callCount,1,"The dialog was hidden")});test("Add transition",function(){var J={show:sinon.spy()},I=this.sandbox.stub().returns(J),K;this.context.mock("workflow-designer/dialogs/add-transition-dialog-view",I);var H=this.createView();H.$(".add-transition").click();equal(I.callCount,1,"An AddTransitionDialogView was created");ok(I.args[0][0].workflowModel===this.workflowModel,"Its constructor was passed the correct arguments");equal(J.show.callCount,1,"The dialog was shown");K=I.args[0][0].transitionModel;ok(!K.has("source"),"The transition doesn't have a source set");ok(!K.has("target"),"The transition doesn't have a target set")});test("Add transition with a status selected",function(){var H=this.sandbox.spy(require("workflow-designer/dialogs/add-transition-dialog-view"));this.context.mock("workflow-designer/dialogs/add-transition-dialog-view",H);var J=this.workflowModel.addStatus();var I=this.createView();var K;this.canvasModel.set("selectedModel",J);I.$(".add-transition").click();K=H.args[0][0].transitionModel;ok(K.get("source")===J,"The transition's source is the selected status");ok(K.get("target")===J,"The transition's target is the selected status")});test("Contains editing buttons in mutable mode",function(){this.createView();equal(this.container.find(".aui-toolbar2-primary").length,1,"Editing buttons are present")});test("Doesn't contain editing buttons in immutable mode",function(){this.createView({immutable:true});equal(this.container.find(".aui-toolbar2-primary").length,0,"Editing buttons are not present")});test("Entering and exiting full screen mode",function(){var I=this.createView(),K=this.container.find(".enter-full-screen"),M=K.tipsy(true),H=this.container.find(".exit-full-screen"),L=H.tipsy(true),J=sinon.spy(),N=sinon.spy();I.on("fullScreen:enter",J);I.on("fullScreen:exit",N);ok(!K.hasClass("hidden"),"Enter full screen button is visible initially");ok(M.enabled,"Enter full screen button tooltip is enabled");ok(H.hasClass("hidden"),"Exit full screen button is hidden initially");ok(!L.enabled,"Exit full screen button tooltip is disabled");K.click();ok(K.hasClass("hidden"),"Enter full screen button is hidden after entering full screen");ok(!M.enabled,"Enter full screen button tooltip is disabled");ok(!H.hasClass("hidden"),"Exit full screen button is visible after entering full screen");ok(L.enabled,"Exit full screen button tooltip is enabled");ok(J.calledOnce,"fullScreen:enter event triggered upon entering full screen");H.click();ok(!K.hasClass("hidden"),"Enter full screen button is visible after exiting full screen");ok(M.enabled,"Enter full screen button tooltip is enabled");ok(H.hasClass("hidden"),"Exit full screen button is hidden after exiting full screen");ok(!L.enabled,"Exit full screen button tooltip is disabled");ok(N.calledOnce,"fullScreen:exit event triggered upon exiting full screen")});test("Events are forwarded from the AddStatusInlineDialogView",function(){var J=C.extend({show:E.noop},G.Events),I=sinon.spy(),H=sinon.spy();this.context.mock("workflow-designer/dialogs/add-status-inline-dialog-view",this.sandbox.stub().returns(J));this.createView().on({"addStatus:done":I,"addStatus:submit":H});this.container.find(".add-status").click();J.trigger("submit");equal(H.callCount,1,"An addStatus:submit event was triggered");J.trigger("done");equal(I.callCount,1,"An addStatus:done event was triggered")});test("Full screen mode can be disabled",function(){this.createView({fullScreenButton:false});equal(this.container.find(".full-screen-trigger").length,0,"No full screen triggers are present")});test('Toggling the "Show Transition Labels" checkbox updates CanvasModel',function(){var H;this.canvasModel.set("showTransitionLabels",false);this.createView();H=this.container.find("#show-transition-labels");ok(!H.is(":checked"),"Checkbox is rendered unchecked when the model attribute is false");this.canvasModel.set("showTransitionLabels",true);this.createView();H=this.container.find("#show-transition-labels");ok(H.is(":checked"),"Checkbox is rendered checked when the model attribute is true");H.attr("checked",true).trigger("change");ok(this.canvasModel.get("showTransitionLabels"),"The model property is true when checkbox is checked");H.attr("checked",false).trigger("change");ok(!this.canvasModel.get("showTransitionLabels"),"The model property is false when checkbox is not checked")});test("The add status inline dialog is recreated on render",function(){var J=C.extend({remove:sinon.stub(),show:sinon.stub()},G.Events),I=this.sandbox.stub().returns(J);this.context.mock("workflow-designer/dialogs/add-status-inline-dialog-view",I);var H=this.createView();H.$(".add-status").click();H.render();equal(J.remove.callCount,1,"The AddStatusInlineDialogView was removed");H.$(".add-status").click();equal(I.callCount,2,"A new AddStatusInlineDialogView was created")});test("Should not render last-saved-by when immutable=true",function(){var H=this.createView({immutable:true});H.render();strictEqual(H._lastSavedByController,undefined)});test("Should render last-saved-by when immutable=false",function(){var H=this.createView({immutable:false});H.render();notEqual(H._lastSavedByController,undefined,"`_lastSavedByController` property should be defined");sinon.assert.calledOnce(H._lastSavedByController.initialize);sinon.assert.called(H._lastSavedByController.show);var I=this.container.find("#workflow-designer-last-saved-by");notEqual(I.html(),"","Last-saved-by should be rendered within provided region")});test("Last-saved-by should use provided options",function(){var H=this.createView({immutable:false});notEqual(H._lastSavedByController,undefined,"`_lastSavedByController` property should be defined");equal(H._lastSavedByController.region,H.lastSavedBy,"incorrect region");equal(H._lastSavedByController._workflowModel,H._workflowModel,"incorrect WorkflowModel");equal(H._lastSavedByController._saveStatusService,H.saveStatusService,"incorrect SaveStatusService")});test("Should close last-saved-by properly",function(){var H=this.createView({immutable:false});notEqual(H._lastSavedByController,undefined,"`_lastSavedByController` property should be defined");this.sandbox.spy(H._lastSavedByController.view,"close");H.render();H.close();sinon.assert.called(H._lastSavedByController.view.close);sinon.assert.calledOnce(H._lastSavedByController.onClose)})});