AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:view-issue-page-workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var WorkflowAJAXManager = require("workflow-designer/io/ajax/workflow-ajax-manager");
    var WorkflowDataReader = require("workflow-designer/io/workflow-data-reader");
    var Messages = require("workflow-designer/messages");
    var Dialog = require("jira/dialog/dialog");
    var TestMocks = require("workflow-designer/test-mocks");
    var TestUtilities = require("workflow-designer/test-utilities");

    var jQuery = require("jquery");
    var realTimeout = window.setTimeout;

    function afterMutations(callback) {
        realTimeout(callback, 4);
    }

    function click(element) {
        var el = (element instanceof jQuery) ? element[0] : element;
        el && el.click && el.click();
    }

    module("ViewIssue", {
        setup: function () {
            var Application = this.Application = TestMocks.Application();

            this.sandbox = sinon.sandbox.create();
            TestMocks.load(this.sandbox, Application);

            this.sandbox.stub(WorkflowAJAXManager, "load");
            this.sandbox.stub(WorkflowAJAXManager, "triggerMauEventForProject");
            this.sandbox.stub(WorkflowDataReader, "read");
            this.sandbox.stub(Messages, "showErrorMessage");
        },

        teardown: function () {
            TestUtilities.removeDialogs();
            this.sandbox.restore();
        }
    });

    asyncTest("Is a web component", function () {
        var a = document.createElement('a');
        a.classList.add("jira-workflow-designer-link");

        equal(a.hasAttribute("resolved"), false, "it should not be resolved yet");
        jQuery("#qunit-fixture").append(a);

        afterMutations(function () {
            equal(a.hasAttribute("resolved"), true, "it is a skated component");
            start();
        });
    });

    asyncTest("Failing to load layout data", function () {
        var loadStub = WorkflowAJAXManager.load,
            showErrorMessageStub = Messages.showErrorMessage,
            trigger = jQuery("<a class='issueaction-viewworkflow jira-workflow-designer-link' href='javascript:'></a>").appendTo("#qunit-fixture");

        afterMutations(function () {
            // Clicking the "View Workflow" link should show an error message
            // saying that the workflow's layout information couldn't be loaded.
            loadStub.returns(jQuery.Deferred().reject());
            click(trigger);

            equal(showErrorMessageStub.callCount, 1, "An error message was displayed");
            equal(Dialog.current, null, "No dialog is visible");
            start();
        });
    });

    asyncTest("clicking the link triggers the workflow dialog", function () {
        var newWorkflowLink,
            loadStub = WorkflowAJAXManager.load,
            workflowImageURL = "?stepId=42&workflowName=Workflow+Name";

        newWorkflowLink = jQuery("<a class='issueaction-viewworkflow jira-workflow-designer-link'></a>")
            .attr("href", workflowImageURL)
            .appendTo("#qunit-fixture");

        afterMutations(function () {
            equal(newWorkflowLink.attr("href"), workflowImageURL, "The new workflow link's href attribute is correct");
            ok(newWorkflowLink.hasClass("new-workflow-designer"), "The new workflow link has the new-workflow-designer class");
            ok(newWorkflowLink.hasClass("issueaction-viewworkflow"), "The new workflow link has the issueaction-viewworkflow class");

            loadStub.returns(jQuery.Deferred().resolve());
            click(newWorkflowLink);

            ok(loadStub.callCount === 1 && loadStub.args[0][0] === "Workflow Name", "The correct workflow name was parsed");
            ok(this.Application.callCount === 1 && this.Application.args[0][0].currentStepId === 42, "The correct step ID was parsed");
            start();
        }.bind(this));

    });

    asyncTest("View workflow dialog", function () {
        var applicationOptions,
            layoutData = {},
            loadStub = WorkflowAJAXManager.load,
            trigger = jQuery("<a class='issueaction-viewworkflow jira-workflow-designer-link' href='javascript:'></a>").appendTo("#qunit-fixture");

        afterMutations(function () {
            // Clicking the "View Workflow" link should show the workflow dialog.
            loadStub.returns(jQuery.Deferred().resolve(layoutData));
            click(trigger);

            ok(Dialog.current !== null, "A dialog is visible");
            equal(this.Application.callCount, 1, "A workflow designer was created");

            applicationOptions = this.Application.args[0][0];
            ok(Dialog.current.get$popup().has(applicationOptions.element).length, "It is shown in the dialog");
            ok(applicationOptions.immutable, "It is immutable");
            start();
        }.bind(this));
    });

});
