AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var LineStartResizeHandle = require("workflow-designer/line-start-resize-handle");
    var GappedConnection = require("workflow-designer/layout/connection/gapped-connection");
    var draw2d = require("workflow-designer/draw-2d");

    module("LineStartResizeHandle");

    test("getGap() gets the gap transformation from a GappedConnection", function () {
        var connection = new GappedConnection(10),
            gap = {x: 10, y: 0},
            resizeHandle;

        sinon.stub(connection, "getStartPointGapTransformation").returns(gap);
        resizeHandle = new LineStartResizeHandle(connection);

        deepEqual(resizeHandle.getGap(), gap);
    });

    test("getGap() returns null gap if the connection is not a GappedConnection", function () {
        var connection = new draw2d.Connection(),
            resizeHandle = new LineStartResizeHandle(connection);

        deepEqual(resizeHandle.getGap(), {x: 0, y: 0});
    });

});
