define("workflow-designer/line-end-resize-handle", [
    "workflow-designer/layout/connection/gapped-connection",
    "workflow-designer/line-resize-handle-mixin",
    "workflow-designer/draw-2d",
    "workflow-designer/cocktail",
], function(
    GappedConnection,
    LineResizeHandleMixin,
    draw2d,
    Cocktail
) {
    /**
     * @class JIRA.WorkflowDesigner.LineEndResizeHandle
     * @classdesc The resize handle for the endpoint of a connection
     * @extends draw2d.shape.basic.LineEndResizeHandle
     * @mixes JIRA.WorkflowDesigner.LineResizeHandleMixin
     */
    var LineEndResizeHandle = draw2d.shape.basic.LineEndResizeHandle.extend(
    /** @lends JIRA.WorkflowDesigner.LineEndResizeHandle# */
    {
        /**
         * Gets the gap that needs to be applied to this resize handle, based on the gap defined in the connection
         *
         * @return {{x: number, y: number}} Gap to apply
         */
        getGap: function() {
            if (this.owner instanceof GappedConnection) {
                return this.owner.getEndPointGapTransformation();
            }
            return {x: 0, y: 0};
        },

        /**
         * @param {JIRA.WorkflowDesigner.StatusPort} port Port to get the drop targets for.
         * @returns {JIRA.WorkflowDesigner.StatusPort[]} Drop targets for the specified port.
         * @private
         */
        _getDropTargets: function(port) {
            return port.getAllTargetPorts();
        }
    });

    Cocktail.mixin(LineEndResizeHandle, LineResizeHandleMixin);

    return LineEndResizeHandle;
});

AJS.namespace("JIRA.WorkflowDesigner.LineEndResizeHandle", null, require("workflow-designer/line-end-resize-handle"));