define("workflow-designer/inline-dialog-svg-positioner", [
    "workflow-designer/svg-utilities",
    "aui/inline-dialog",
    "workflow-designer/backbone",
    "workflow-designer/underscore",
    "jquery"
], function(
    SVGUtilities,
    InlineDialog,
    Backbone,
    _,
    jQuery
) {
    /**
     * @namespace
     */
    return {
        /**
         * Position an inline dialog on an SVG element.
         *
         * @param {element} element The inline dialog's element.
         * @param {object} targetPosition
         * @param {element} targetPosition.target The element under which the inline dialog is to be positioned.
         * @param {object} mousePosition
         * @param {number} mousePosition.x
         * @param {number} mousePosition.y
         * @param {object} options The inline dialog's options.
         */
        calculatePosition: function (element, targetPosition, mousePosition, options) {
            var boundingBox,
                result,
                targetElement;

            // Create a dummy element with the same position and size as the target element.
            boundingBox = SVGUtilities.getPageBoundingBox(targetPosition.target);
            targetElement = jQuery("<div/>").css({
                height: boundingBox.height,
                left: boundingBox.x,
                position: "absolute",
                top: boundingBox.y,
                width: boundingBox.width
            }).appendTo("body");

            result = InlineDialog.opts.calculatePositions(element, {target: targetElement}, mousePosition, options);
            targetElement.remove();
            return result;
        }
    };
});

AJS.namespace("JIRA.WorkflowDesigner.InlineDialogSVGPositioner", null, require("workflow-designer/inline-dialog-svg-positioner"));