AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var FullScreenController = require("workflow-designer/full-screen-controller");
    var jQuery = require("jquery");

    module("FullScreenController", {
        setup: function () {
            this.element = jQuery("<div>").appendTo("#qunit-fixture").css({height: 100, width: 100});
            this.fullScreenController = FullScreenController;
        },

        teardown: function () {
            jQuery("body").css("overflow", "visible");
            this.element.remove();
        }
    });

    asyncTest("enterFullScreen()", function () {
        var element = this.element,
            instance = this;

        this.fullScreenController.enterFullScreen(element).done(function () {
            var expectedOffset = {
                left: jQuery(document).scrollLeft(),
                top: jQuery(document).scrollTop()
            };

            deepEqual(element.offset(), expectedOffset, "The element is positioned at the top-left of the window");
            equal(element.outerHeight(), jQuery(window).outerHeight(), "The element is the same height as the window");
            equal(element.outerWidth(), jQuery(window).outerWidth(), "The element is the same width as the window");
            equal(jQuery("body").css("overflow"), "hidden", "The document's scroll bars are hidden");
            instance.fullScreenController.exitFullScreen(element).done(start);
        });
    });

    asyncTest("exitFullScreen()", function () {
        var body = jQuery("body"),
            element = this.element,
            instance = this,
            originalHeight = element.outerHeight(),
            originalOverflow = body.css("overflow"),
            originalWidth = element.outerWidth();

        this.fullScreenController.enterFullScreen(element).done(function () {
            instance.fullScreenController.exitFullScreen(element).done(function () {
                ok(element.closest("#qunit-fixture").length === 1, "The element was restored to its original location");
                equal(element.outerHeight(), originalHeight, "The element's original height was restored");
                equal(element.outerWidth(), originalWidth, "The element's original width was restored");
                equal(body.css("overflow"), originalOverflow, "The document's original overflow value was restored");
                start();
            });
        });
    });

});
