(function () {
    var FigureUtilities = require("workflow-designer/figure-utilities");
    var draw2d = require("workflow-designer/draw-2d");
    var _ = require("workflow-designer/underscore");

    /**
     * Patch Draw2D's PolyLine class.
     */
    _.extend(draw2d.shape.basic.PolyLine.prototype, {
        /**
         * @return {draw2d.geo.Rectangle} the bounding box containing all points of this poly-line.
         */
        getBoundingBox: function() {
            var linePoints = this.getPoints().asArray();

            return FigureUtilities.calculateBoundingBox(linePoints);
        }
    });
}());