AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var Vector2D = require("workflow-designer/vector-2d");
    var draw2d = require("workflow-designer/draw-2d");
    var _ = require("workflow-designer/underscore");

    module("Vector2D", {
        createVector: function (components) {
            var vector = new this.vector2D(0, 0);
            this.vector2D.apply(vector, components);
            return vector;
        },

        setup: function () {
            this.vector2D = Vector2D;
        }
    });

    test("initialize()", function () {
        var end, start, vector;

        vector = new Vector2D(42, 1337);
        equal(vector.x, 42, "The vector's x component is correct");
        equal(vector.y, 1337, "The vector's y component is correct");

        end = new draw2d.geo.Point(48, 1340);
        start = new draw2d.geo.Point(6, 3);
        vector = new Vector2D(start, end);
        equal(vector.x, 42, "The vector's x component is correct");
        equal(vector.y, 1337, "The vector's y component is correct");
    });

    test("length()", function () {
        var tests,
            x = Math.sqrt(8);

        // [vector, expected length]
        tests = [
            [[0.5, 0], 0.5],
            [[1, 0], 1],
            [[-1, 0], 1],
            [[0, 1], 1],
            [[0, -1], 1],
            [[2, 2], x],
            [[-2, 2], x],
            [[-2, -2], x],
            [[2, -2], x]
        ];

        _.each(tests, function (test) {
            var actual = this.createVector(test[0]).getLength(),
                expected = test[1];

            equal(actual, expected, [
                "The length of (", test[0], ") is ", test[1]
            ].join(""));
        }, this);
    });

    test("multiply()", function () {
        // [vector, factor, expected result]
        var tests = [
            [[1, 0], 2, [2, 0]],
            [[-1, 0], 2, [-2, 0]],
            [[0, 1], 2, [0, 2]],
            [[0, -1], 2, [0, -2]],
            [[1, 1], 2, [2, 2]]
        ];

        _.each(tests, function (test) {
            var actual = this.createVector(test[0]).multiply(test[1]),
                expected = this.createVector(test[2]);

            ok(actual.equals(expected), [
                "Multiplying (", test[0], ") by ", test[1], " results in (", test[2], ")"
            ].join(""));
        }, this);
    });

    test("normalize()", function () {
        var tests,
            x = 1 / Math.sqrt(2);

        // [vector, expected result]
        tests = [
            [[0, 0], [0, 0]],
            [[2, 0], [1, 0]],
            [[-2, 0], [-1, 0]],
            [[0, 2], [0, 1]],
            [[0, -2], [0, -1]],
            [[2, 2], [x, x]]
        ];

        _.each(tests, function (test) {
            var actual = this.createVector(test[0]).normalize(),
                expected = this.createVector(test[1]);

            ok(actual.equals(expected), [
                "The normalised form of (", test[0], ") is (", test[1], ")"
            ].join(""));
        }, this);
    });

});
