AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var Validator = require("workflow-designer/validator");
    var WorkflowModel = require("workflow-designer/workflow-model");
    var WorkflowValidationAJAXManager = require("workflow-designer/io/ajax/validation-ajax-manager");

    module("Validator", {
        setup: function () {
            this.validator = Validator;

            this.workflowModel = new WorkflowModel();

            this.validationResult = {
                nodeProblems: {
                    "1": [
                        {
                            "message": "node problem",
                            "severity": "MAJOR"
                        },
                        {
                            "message": "critical node problem",
                            "severity": "CRITICAL"
                        }
                    ],
                    "2": [
                        {
                            "message": "just info",
                            "severity": "MINOR"
                        }
                    ]
                },
                edgeProblems: {
                    "A<S<1>,S<1>>": [
                        {
                            "message": "minor edge problem",
                            "severity": "MINOR"
                        },
                        {
                            "message": "edge problem",
                            "severity": "MAJOR"
                        }
                    ]
                }
            };

            this.expectedNodeValidationResult = {
                1: {
                    "alterDisplay": true,
                    "color": "#d04437",
                    "mostSevere": {
                        "message": "critical node problem",
                        "severity": "CRITICAL"
                    }
                },
                2: {
                    alterDisplay: false,
                    color: false,
                    mostSevere: {
                        "message": "just info",
                        "severity": "MINOR"
                    }
                }
            };

            this.expectedEdgeValidationResult = {
                "A<S<1>,S<1>>": {
                    "alterDisplay": true,
                    "color": "#d04437",
                    "mostSevere": {
                        "message": "edge problem",
                        "severity": "MAJOR"
                    }
                }
            };

            var validationResult = this.validationResult;
            WorkflowValidationAJAXManager.check = sinon.spy(function () {
                return {
                    done: function (callback) {
                        callback(validationResult); // execute the callback immediately
                        return this;
                    },
                    fail: function () {
                    }
                };
            });

            this.disableDarkFeature = function (disabled) {
                AJS.DarkFeatures.isEnabled = function (feature) {
                    return feature === "jira.administration.workflow.validation.disabled" && disabled;
                };
            };
        }
    });

    test("validation:transitions event is raised correctly after successful validation", function () {
        this.disableDarkFeature(false);
        var transitionProblems;
        var util;
        this.workflowModel.on("validation:transitions", function (result, eventUtil) {
            transitionProblems = result;
            util = eventUtil;
        });
        this.validator.validate(this.workflowModel);
        deepEqual(transitionProblems, this.expectedEdgeValidationResult, "validation:transitions event is raised after successful validation with correct results");
    });

    test("validation:statuses event is raised correctly after successful validation", function () {
        this.disableDarkFeature(false);
        var nodeProblems;
        this.workflowModel.on("validation:statuses", function (result) {
            nodeProblems = result;
        });
        this.validator.validate(this.workflowModel);
        deepEqual(nodeProblems, this.expectedNodeValidationResult, "validation:statuses event is raised after successful validation with correct results");
    });

    test("validation can be disabled using a dark feature", function () {
        this.disableDarkFeature(true);
        this.validator.validate(this.workflowModel);
        equal(WorkflowValidationAJAXManager.check.callCount, 0, "validation should not be called when dark feature is disabled");
    });

});
