define("workflow-designer/test-mocks", [
    "workflow-designer/application-loader",
    "workflow-designer/status-model",
    "workflow-designer/draw-2d",
    "jquery"
], function (
    ApplicationLoader,
    StatusModel,
    draw2d,
    jQuery
) {

    /**
     * Mocks for testing.
     *
     * @namespace
     */
    return {
        /**
         * @param {string} action Value to use in the action property
         * @param {string} object Value to use in the object property
         * @returns {{name: string, properties: {mode: string, action: *, object: *}}} Mocked analytics event
         */
        analyticsEditEvent: function (action, object) {
            return {
                name: "administration.workflow.edit",
                properties: {
                    mode: "new-diagram",
                    action: action,
                    object: object
                }
            };
        },

        /**
         * @returns {Object} A mock {@link JIRA.WorkflowDesigner.Application}
         */
        Application: function () {
            return sinon.stub().returns({
                destroy: sinon.stub()
            });
        },

        /**
         * @param {number[]} bounds The figure's bounds.
         * @return {object} A mock {@link draw2d.Figure} with the given bounds.
         */
        figure: function (bounds) {
            return {
                getBoundingBox: function () {
                    var boundingBox = new draw2d.geo.Rectangle();
                    draw2d.geo.Rectangle.constructor.apply(boundingBox, bounds);
                    return boundingBox;
                }
            };
        },

        /**
         * @return {object} A mock {@link draw2d.Port}
         */
        port: function() {
            return {
                getConnectionDirection: sinon.stub()
            };
        },

        /**
         * @param {string} id Status ID.
         * @param {number[]} size The view's size.
         * @param {number[]|null[]} [coordinates=[null,null]] The model's coordinates.
         * @param {boolean} [initial=false] Whether the status is initial.
         * @return {object} A mock {@link JIRA.WorkflowDesigner.StatusView}.
         */
        statusView: function (id, size, coordinates, initial) {
            coordinates || (coordinates = [null, null]);

            return {
                getBoundingBox: function () {
                    return new draw2d.geo.Rectangle(0, 0, size[0], size[1]);
                },
                model: new StatusModel({
                    id: id,
                    initial: !!initial,
                    x: coordinates[0],
                    y: coordinates[1]
                }),
                setPosition: sinon.stub()
            };
        },

        /**
         * @param {Object} sinon Sinon main object (or a sinon sandbox) used to create the stubs.
         * @param {Object} application The workflow designer application constructor.
         * @returns {Object} A mock {@link JIRA.WorkflowDesigner.require} that always synchronously executes its
         *   callback with {@link JIRA.WorkflowDesigner.Application}.
         */
        load: function (sinon, application) {
            return sinon.stub(ApplicationLoader, "load", function (callback) {
                callback && callback(application);
                return jQuery.Deferred().resolve();
            });
        }
    };
});
