AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var SVGUtilities = require("workflow-designer/svg-utilities");
    var _ = require("workflow-designer/underscore");
    var jQuery = require("jquery");
    
    module("SVGUtilities", {
        setup: function () {
            this.svg = jQuery(document.createElementNS("http://www.w3.org/2000/svg", "svg")).appendTo("body");
            this.svg.attr({
                height: 100,
                preserveAspectRatio: "xMinYMin",
                version: "1.1",
                width: 100,
                xmlns: "http://www.w3.org/2000/svg"
            });
            this.svg.css({
                height: "100px",
                left: 0,
                position: "absolute",
                top: 0,
                width: "100px"
            });
        },

        teardown: function () {
            jQuery("body").css({height: "", width: ""});
            this.svg.remove();
        },

        equalPoints: function (a, b) {
            var epsilon = 0.01,
                message;

            message = ["(", a.x, ", ", a.y, ") equals (", b.x, ", ", b.y, ")."].join("");
            ok((a.x - b.x) < epsilon && (a.y - b.y) < epsilon, message);
        }
    });

    test("fromScreenToSVGCoordinate()", function () {
        var fromScreenToSVGCoordinate = _.bind(SVGUtilities.fromScreenToSVGCoordinate, this, this.svg);
        jQuery(document).scrollLeft(0).scrollTop(0);

        // Equal origins, sizes.
        this.equalPoints(fromScreenToSVGCoordinate(-100, -100), {x: -100, y: -100});
        this.equalPoints(fromScreenToSVGCoordinate(0, 0), {x: 0, y: 0});
        this.equalPoints(fromScreenToSVGCoordinate(100, 100), {x: 100, y: 100});
        this.equalPoints(fromScreenToSVGCoordinate(200, 200), {x: 200, y: 200});

        // Different origins, same sizes.
        this.svg.css({left: "100px", top: "100px"});
        this.equalPoints(fromScreenToSVGCoordinate(0, 0), {x: -100, y: -100});
        this.equalPoints(fromScreenToSVGCoordinate(100, 100), {x: 0, y: 0});
        this.equalPoints(fromScreenToSVGCoordinate(200, 200), {x: 100, y: 100});
        this.equalPoints(fromScreenToSVGCoordinate(300, 300), {x: 200, y: 200});

        // Same origins, different sizes.
        this.svg.css({left: 0, top: 0});
        this.svg.get(0).setAttribute("viewBox", "0 0 200 200");
        this.equalPoints(fromScreenToSVGCoordinate(-100, -100), {x: -200, y: -200});
        this.equalPoints(fromScreenToSVGCoordinate(0, 0), {x: 0, y: 0});
        this.equalPoints(fromScreenToSVGCoordinate(100, 100), {x: 200, y: 200});
        this.equalPoints(fromScreenToSVGCoordinate(200, 200), {x: 400, y: 400});

        // Different origins, different sizes.
        this.svg.css({left: "100px", top: "100px"});
        this.equalPoints(fromScreenToSVGCoordinate(0, 0), {x: -200, y: -200});
        this.equalPoints(fromScreenToSVGCoordinate(100, 100), {x: 0, y: 0});
        this.equalPoints(fromScreenToSVGCoordinate(200, 200), {x: 200, y: 200});
        this.equalPoints(fromScreenToSVGCoordinate(300, 300), {x: 400, y: 400});
    });

    test("fromSVGToPageCoordinate()", function () {
        var fromSVGToPageCoordinate = _.bind(SVGUtilities.fromSVGToPageCoordinate, this, this.svg);

        jQuery("body").css({height: "200%", width: "200%"});
        jQuery(document).scrollLeft(100).scrollTop(100);
        this.svg.css({left: "100px", top: "100px"});

        this.equalPoints(fromSVGToPageCoordinate(-100, -100), {x: 0, y: 0});
        this.equalPoints(fromSVGToPageCoordinate(0, 0), {x: 100, y: 100});
        this.equalPoints(fromSVGToPageCoordinate(100, 100), {x: 200, y: 200});
    });

    test("fromSVGToScreenCoordinate()", function () {
        var fromSVGToScreenCoordinate = _.bind(SVGUtilities.fromSVGToScreenCoordinate, this, this.svg);
        jQuery(document).scrollLeft(0).scrollTop(0);

        // Equal origins, sizes.
        this.equalPoints(fromSVGToScreenCoordinate(-100, -100), {x: -100, y: -100});
        this.equalPoints(fromSVGToScreenCoordinate(0, 0), {x: 0, y: 0});
        this.equalPoints(fromSVGToScreenCoordinate(100, 100), {x: 100, y: 100});
        this.equalPoints(fromSVGToScreenCoordinate(200, 200), {x: 200, y: 200});

        // Different origins, same sizes.
        this.svg.css({left: "100px", top: "100px"});
        this.equalPoints(fromSVGToScreenCoordinate(-100, -100), {x: 0, y: 0});
        this.equalPoints(fromSVGToScreenCoordinate(0, 0), {x: 100, y: 100});
        this.equalPoints(fromSVGToScreenCoordinate(100, 100), {x: 200, y: 200});
        this.equalPoints(fromSVGToScreenCoordinate(200, 200), {x: 300, y: 300});

        // Same origins, different sizes.
        this.svg.css({left: 0, top: 0});
        this.svg.get(0).setAttribute("viewBox", "0 0 200 200");
        this.equalPoints(fromSVGToScreenCoordinate(-100, -100), {x: -50, y: -50});
        this.equalPoints(fromSVGToScreenCoordinate(0, 0), {x: 0, y: 0});
        this.equalPoints(fromSVGToScreenCoordinate(100, 100), {x: 50, y: 50});
        this.equalPoints(fromSVGToScreenCoordinate(200, 200), {x: 100, y: 100});

        // Different origins, different sizes.
        this.svg.css({left: "100px", top: "100px"});
        this.equalPoints(fromSVGToScreenCoordinate(-100, -100), {x: 50, y: 50});
        this.equalPoints(fromSVGToScreenCoordinate(0, 0), {x: 100, y: 100});
        this.equalPoints(fromSVGToScreenCoordinate(100, 100), {x: 150, y: 150});
        this.equalPoints(fromSVGToScreenCoordinate(200, 200), {x: 200, y: 200});
    });

});
