AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-io",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var Messages = require("workflow-designer/messages");
    var JIRAMessages = require("jira/message");
    var _ = require("workflow-designer/underscore");
    var jQuery = require("jquery");

    module("Messages", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(JIRAMessages, "showErrorMsg").returns(jQuery("<div>"));
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("showErrorMessage()", function () {
        var message = "Hello!",
            result = Messages.showErrorMessage(message);

        equal(JIRAMessages.showErrorMsg.callCount, 1, "JIRA.Messages.showErrorMsg was called");
        deepEqual(JIRAMessages.showErrorMsg.args[0], [message, {
            closeable: true,
            timeout: 0
        }], "It was passed the correct arguments");
        equal(result.css("z-index"), "2510", "The element's z-index was set");
    });

    test("showErrorMessage() does nothing if the message is empty", function () {
        _.each([null, undefined, ""], function (message) {
            Messages.showErrorMessage(message);
            equal(JIRAMessages.showErrorMsg.callCount, 0, "JIRA.Messages.showErrorMsg wasn't called");
        });
    });

});
