define("workflow-designer/figure-utilities", [
    "workflow-designer/draw-2d",
    "workflow-designer/underscore"
], function(
    draw2d,
    _
) {
    /**
     * Figure-related utility methods.
     *
     * @namespace
     */
    return  {
        /**
         * Calculates the bounding box that contains all given points.
         *
         * @param {draw2d.geo.Point[]} points Array of points.
         * @return {draw2d.geo.Rectangle} the bounding box containing all given points.
         */
        calculateBoundingBox: function (points) {
            var minX = null, maxX = null,
                minY = null, maxY = null,
                width, height;

            _.each(points, function(point) {
                var pointX = point.getX(),
                    pointY = point.getY();

                if (!minX || minX > pointX) {
                    minX = pointX;
                }
                if (!maxX || maxX < pointX) {
                    maxX = pointX;
                }
                if (!minY || minY > pointY) {
                    minY = pointY;
                }
                if (!maxY || maxY < pointY) {
                    maxY = pointY;
                }
            });

            width = maxX - minX;
            height = maxY - minY;

            return new draw2d.geo.Rectangle(minX, minY, width, height);
        }
    };
});

AJS.namespace("JIRA.WorkflowDesigner.FigureUtilities", null, require("workflow-designer/figure-utilities"));