AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:dialog",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var Dialog = require("workflow-designer/dialog");
    var JIRADialog = require("jira/dialog/dialog");
    var DialogSizeCalculator = require("workflow-designer/dialog-size-calculator");
    var TestUtilities = require("workflow-designer/test-utilities");
    var TestMocks = require("workflow-designer/test-mocks");

    module("DialogSizeCalculator", {
        setup: function () {
            var Application = TestMocks.Application();
            this.sandbox = sinon.sandbox.create();
            TestMocks.load(this.sandbox, Application);
        },

        teardown: function () {
            TestUtilities.removeDialogs();
            this.sandbox.restore();
        },

        showDialog: function () {
            return new Dialog({
                id: "workflow-dialog",
                workflowId: function () {
                    return "workflow";
                },
                currentStepId: function () {
                    return "1";
                }
            }).show();
        }
    });

    test("Dialog size is recalculated based on window size", function () {
        this.showDialog();
        var size = DialogSizeCalculator.calculateDialogSize(JIRADialog.current, {
            windowHeight: 1000,
            windowWidth: 1000,
            dialogHeaderHeight: 50,
            dialogFooterHeight: 50
        });

        equal(size.width, 800, "Width is 200 less than window.'");
        equal(size.height, 700, "Height is 200 + dialog footer/header height less than window.'");
    });

});
