AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var BrowserUtilities = require("workflow-designer/browser-utilities");
    var BrowserZoomChecker = require("workflow-designer/browser-zoom-checker");
    var jQuery = require("jquery");
    var _ = require("workflow-designer/underscore");

    module("BrowserZoomChecker", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();
            this.sandbox.stub(BrowserUtilities, "getZoomLevel");
            this.errorMsg = {
                css: sinon.spy(),
                is: sinon.spy(),
                remove: sinon.spy()
            };
            this.sandbox.stub(JIRA.Messages, "showErrorMsg").returns(this.errorMsg);

            this.browserZoomChecker = new BrowserZoomChecker();
        },

        teardown: function () {
            this.sandbox.restore();
            this.browserZoomChecker.destroy();
        }
    });

    test("Unsupported zoom level error message is shown if browser is zoomed out", function () {
        BrowserUtilities.getZoomLevel.returns(0.9);
        this.browserZoomChecker._check();
        equal(JIRA.Messages.showErrorMsg.callCount, 1, "Error message was shown");
    });

    test("Unsupported zoom level error message is shown if browser is zoomed in", function () {
        BrowserUtilities.getZoomLevel.returns(1.1);
        this.browserZoomChecker._check();
        equal(JIRA.Messages.showErrorMsg.callCount, 1, "Error message was shown");
    });

    test("Unsupported zoom level error message is cleared if browser zoom is reset", function () {
        var removeMessageSpy = sinon.spy();

        BrowserUtilities.getZoomLevel.returns(1.1);
        JIRA.Messages.showErrorMsg.returns({
            css: jQuery.noop,
            remove: removeMessageSpy
        });

        this.browserZoomChecker._check();

        BrowserUtilities.getZoomLevel.returns(1);
        this.browserZoomChecker._check();

        equal(removeMessageSpy.callCount, 1, "Error message was cleared");

        ok(_.isUndefined(this.browserZoomChecker._browserZoomMessage), "Error message closed");
    });

    test("Zoom check is not performed while window is being resized", function () {
        this.browserZoomChecker._windowIsResizing = true;
        this.browserZoomChecker._check();

        this.browserZoomChecker._windowIsResizing = false;
        this.browserZoomChecker._check();

        equal(BrowserUtilities.getZoomLevel.callCount, 1, "Zoom level was only checked when window was not being resized");
    });

    test("isErrorDisplayed uses the error message visibility", function () {
        var isVisible = true;
        this.errorMsg.is = sinon.stub().returns(isVisible);

        BrowserUtilities.getZoomLevel.returns(1.4);
        this.browserZoomChecker._check();

        equal(this.browserZoomChecker.isErrorMessageDisplayed(), isVisible, "Displaying zoom error message");
        ok(this.errorMsg.is.calledOnce);
        deepEqual(this.errorMsg.is.firstCall.args, [":visible"]);
    });

    test("Don't display error message when error message closed", function () {
        var isVisible = true;
        var isNotVisible = true;
        this.errorMsg.is = sinon.stub().returns(isVisible);

        BrowserUtilities.getZoomLevel.returns(1.4);
        this.browserZoomChecker._check();

        equal(this.browserZoomChecker.isErrorMessageDisplayed(), isVisible, "Displaying zoom error message");

        //Close the message (done by user)
        this.errorMsg.is = sinon.stub().returns(isNotVisible);

        this.browserZoomChecker._check();

        equal(this.browserZoomChecker.isErrorMessageDisplayed(), isNotVisible, "Error message no longer displayed");

        this.browserZoomChecker._check();
    });

});
