define("workflow-designer/policy/feedback/line-selection-feedback-policy", [
    "workflow-designer/line-start-resize-handle",
    "workflow-designer/line-end-resize-handle",
    "workflow-designer/draw-2d"
], function(
    LineStartResizeHandle,
    LineEndResizeHandle,
    draw2d
) {
    /**
     * @class JIRA.WorkflowDesigner.Policy.Feedback.LineSelectionFeedbackPolicy
     * @extends draw2d.policy.figure.LineSelectionFeedbackPolicy
     */
    return draw2d.policy.figure.LineSelectionFeedbackPolicy.extend(
    /** @lends JIRA.WorkflowDesigner.Policy.Feedback.LineSelectionFeedbackPolicy# */
    {
        /**
         * Creates the ResizeHandle for the start of the connection
         *
         * @param {draw2d.Figure} figure
         * @returns {JIRA.WorkflowDesigner.LineStartResizeHandle}
         */
        createLineStartResizeHandle: function(figure) {
            return new LineStartResizeHandle(figure);
        },

        /**
         * Creates the ResizeHandle for the end of the connection
         *
         * @param {draw2d.Figure} figure
         * @returns {JIRA.WorkflowDesigner.LineEndResizeHandle}
         */
        createLineEndResizeHandle: function(figure) {
            return new LineEndResizeHandle(figure);
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.Policy.Feedback.LineSelectionFeedbackPolicy", null, require("workflow-designer/policy/feedback/line-selection-feedback-policy"));