AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var SnapPoints = require("workflow-designer/policy/canvas/snap-to-geometry/snap-points");
    var draw2d = require("workflow-designer/draw-2d");
    var _ = require("workflow-designer/underscore");

    module("SnapPoints", {
        makeFigure: function (x, y, w, h) {
            return {
                getBoundingBox: function () {
                    return new draw2d.geo.Rectangle(x, y, w, h);
                }
            };
        },

        makeSnapPoints: function (figure, values) {
            return _.map(values, this.SnapPoints._makeSnapPoint(figure));
        },

        setup: function () {
            this.SnapPoints = SnapPoints;
        }
    });

    test("Passing a single figure to getXSnapPoints()", function () {
        var expected,
            figure = this.makeFigure(0, 0, 1, 1),
            result = this.SnapPoints.getXSnapPoints(figure);

        expected = this.makeSnapPoints(figure, [0, 0.5, 1]);
        deepEqual(result, expected, "The correct snap points were returned");
    });

    test("Passing multiple figures to getXSnapPoints()", function () {
        var expected,
            figure1 = this.makeFigure(10, 10, 10, 10),
            figure2 = this.makeFigure(20, 20, 20, 10),
            result = this.SnapPoints.getXSnapPoints([figure1, figure2]);

        expected = _.flatten([
            this.makeSnapPoints(figure1, [10, 15, 20]),
            this.makeSnapPoints(figure2, [20, 30, 40])
        ]);

        deepEqual(result, expected, "The correct snap points were returned");
    });

    test("Passing a single figure to getYSnapPoints()", function () {
        var expected,
            figure = this.makeFigure(0, 0, 1, 1),
            result = this.SnapPoints.getYSnapPoints(figure);

        expected = this.makeSnapPoints(figure, [0, 1]);
        deepEqual(result, expected, "The correct snap points were returned");
    });

    test("Passing multiple figures to getYSnapPoints()", function () {
        var expected,
            figure1 = this.makeFigure(10, 10, 10, 10),
            figure2 = this.makeFigure(20, 20, 10, 20),
            result = this.SnapPoints.getYSnapPoints([figure1, figure2]);

        expected = _.flatten([
            this.makeSnapPoints(figure1, [10, 20]),
            this.makeSnapPoints(figure2, [20, 40])
        ]);

        deepEqual(result, expected, "The correct snap points were returned");
    });

});
