AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-models","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var A=require("workflow-designer/status-model");var B=require("workflow-designer/transition-model");var C=require("workflow-designer/workflow-model");module("WorkflowModel",{setup:function(){this.workflowModel=new C();this.sandbox=sinon.sandbox.create()},teardown:function(){this.sandbox.restore()}});test("addStatus()",function(){var E,D,F=this.workflowModel.get("statuses");E={description:"",id:"id",stepId:42,statusCategory:null,statusId:"42",name:"Status",initial:false,x:42,y:1337,validations:null};D=this.workflowModel.addStatus({id:"id",stepId:42,statusId:"42",name:"Status",x:42,y:1337});ok(D instanceof A,"The new StatusModel was returned");deepEqual(E,D.attributes,"Its attributes are correct");ok(F.length===1&&F.at(0)===D,"It was added to the StatusCollection")});test("addTransition()",function(){var D,F=new A({id:"source"}),H=new A({id:"target"}),I,G=this.workflowModel.get("transitions"),E=sinon.spy();this.workflowModel.bind("layoutChanged",E);D={id:"A<1:source:target>",actionId:1,description:null,globalTransition:false,loopedTransition:false,name:"Transition",source:F,sourceAngle:90,target:H,targetAngle:-90,screenId:null,screenName:null,validations:null,transitionOptions:[{name:"properties",count:3,url:"/properties/url",weight:10},{name:"conditions",count:2,url:"/conditions/url",weight:100}]};I=this.workflowModel.addTransition({actionId:1,globalTransition:false,loopedTransition:false,name:"Transition",source:F,sourceAngle:90,target:H,targetAngle:-90,transitionOptions:[{name:"properties",count:3,url:"/properties/url",weight:10},{name:"conditions",count:2,url:"/conditions/url",weight:100}]});ok(I instanceof B,"The new TransitionModel was returned");deepEqual(I.attributes,D,"Its attributes are correct");ok(G.length===1&&G.at(0)===I,"It was added to the WorkflowModel's TransitionCollection");ok(E.called,"A layoutChanged event was triggered")});test("addTransition() global transition",function(){var E,D=new A({id:"status"}),G,F=this.workflowModel.get("transitions");E={id:"A<1:status:status>",actionId:1,description:"Resolve the issue!",globalTransition:true,loopedTransition:false,name:"Resolve",source:D,sourceAngle:null,target:D,targetAngle:null,screenName:"Resolve View",screenId:2,transitionOptions:[{name:"properties",count:3,url:"/properties/url",weight:10},{name:"conditions",count:2,url:"/conditions/url",weight:100}],validations:null};G=this.workflowModel.addTransition({actionId:1,description:"Resolve the issue!",globalTransition:true,loopedTransition:false,name:"Resolve",source:D,target:D,screenName:"Resolve View",screenId:2,transitionOptions:[{name:"properties",count:3,url:"/properties/url",weight:10},{name:"conditions",count:2,url:"/conditions/url",weight:100}]});ok(G instanceof B,"The new TransitionModel was returned");deepEqual(G.attributes,E,"Its attributes are correct");ok(F.length===1&&F.at(0)===G,"It was added to the WorkflowModel's TransitionCollection")});test("addTransition() looped transition",function(){var D,F,E=this.workflowModel.get("transitions");D={id:"A<1:S<-1>:S<-1>>",actionId:1,description:"A global Loop",globalTransition:false,loopedTransition:true,name:"Resolve",source:null,sourceAngle:null,target:null,targetAngle:null,screenName:"Resolve View",screenId:2,transitionOptions:[{name:"properties",count:3,url:"/properties/url",weight:10},{name:"conditions",count:2,url:"/conditions/url",weight:100}],validations:null};F=this.workflowModel.addTransition({actionId:1,description:"A global Loop",globalTransition:false,loopedTransition:true,name:"Resolve",screenName:"Resolve View",screenId:2,transitionOptions:[{name:"properties",count:3,url:"/properties/url",weight:10},{name:"conditions",count:2,url:"/conditions/url",weight:100}]});ok(F instanceof B,"The new TransitionModel was returned");deepEqual(F.attributes,D,"Its attributes are correct");ok(E.length===1&&E.at(0)===F,"It was added to the WorkflowModel's TransitionCollection")});test("getGlobalTransitionForStatus()",function(){var E,D=this.workflowModel.addStatus({});ok(this.workflowModel.getGlobalTransitionForStatus(D)===undefined,"Returns undefined when the status doesn't have a global transition");E=this.workflowModel.addTransition({globalTransition:true,target:D});ok(this.workflowModel.getGlobalTransitionForStatus(D)===E,"Returns the correct TransitionModel when the status has a global transition")});test("getStatus()",function(){var D;ok(this.workflowModel.getStatus("open")===undefined,"Returns undefined when no status is found");D=this.workflowModel.addStatus({id:"open"});ok(this.workflowModel.getStatus("open")===D,"Returns the correct StatusModel when a status is found")});test("reset() doesn't trigger new:* events on initial load",function(){var D=sinon.spy();this.workflowModel.on("new:status new:transition",D);this.workflowModel.reset({statuses:[new A()],transitions:[new B()]});equal(D.callCount,0,"No new:* events were triggered")});test("reset() resets the model to a given state",function(){var D,E,F=this.workflowModel.get("statuses"),H,G=this.workflowModel.get("transitions");equal(F.length,0,"The model contains no statuses");equal(G.length,0,"The model contains no transitions");D=new A({name:"Closed"});E=new A({name:"Open"});H=new B({name:"Close",source:E,target:D});this.workflowModel.reset({statuses:[D,E],transitions:[H]});equal(F.length,2,"The model contains the correct number of statuses");equal(G.length,1,"The model contains the correct number of transitions");this.workflowModel.reset({draft:true,name:"Different Name",statuses:[],transitions:[]});equal(this.workflowModel.get("draft"),true,"The model's draft status is correct");equal(this.workflowModel.get("name"),"Different Name","The model's name is correct");equal(F.length,0,"The model contains the correct number of statuses");equal(G.length,0,"The model contains the correct number of transitions")});test("reset() triggers a new:status event if there is a single new status",function(){var D=new A({id:"Closed"}),F=new A({id:"In Progress"}),E=new A({id:"Open"}),H=new A({id:"Pull Request"}),G=sinon.spy();this.workflowModel.addStatus(D);this.workflowModel.on("new:status",G);this.workflowModel.reset({statuses:[D,F],transitions:[]});equal(G.callCount,1,"A new:status event is triggered when there is a single new status");ok(G.args[0][0]===F,"The new status was passed as an argument");this.workflowModel.reset({statuses:[D,F,E,H],transitions:[]});equal(G.callCount,1,"No new:status event is triggered when there are multiple new statuses")});test("reset() triggers a new:transition event if there is a single new transition",function(){var H=new B({id:"Closed"}),D=new B({id:"Pull Request"}),E=sinon.spy(),G=new B({id:"In Progress"}),F=new B({id:"Open"});this.workflowModel.addTransition(H);this.workflowModel.on("new:transition",E);this.workflowModel.reset({statuses:[],transitions:[H,D]});equal(E.callCount,1,"A new:transition event is triggered when there is a single new transition");ok(E.args[0][0]===D,"The new transition was passed as an argument");this.workflowModel.reset({statuses:[],transitions:[H,D,G,F]});equal(E.callCount,1,"No new:transition event is triggered when there are multiple new transitions")});test("Triggers a layoutChanged event when status coordinates change",function(){var E=sinon.spy(),D;D=this.workflowModel.addStatus({id:"id",name:"Status",stepId:1,x:0,y:0});this.workflowModel.bind("layoutChanged",E);D.set({x:0,y:0});ok(!E.called,"A layoutChanged event wasn't triggered");D.set({x:10,y:10});ok(E.called,"A layoutChanged event was triggered")});test("Triggers a layoutChanged event when transition action ID changes value",function(){var D=sinon.spy(),E=this.workflowModel.addTransition({actionId:1});this.workflowModel.bind("layoutChanged",D);E.set({actionId:1});ok(!D.called,"A layoutChanged event wasn't triggered");E.set({actionId:2});ok(D.called,"A layoutChanged event was triggered")});test("Triggers a layoutChanged event when transition angles change",function(){var D=sinon.spy(),E=this.workflowModel.addTransition({sourceAngle:90,targetAngle:-90});this.workflowModel.bind("layoutChanged",D);E.set({sourceAngle:90,targetAngle:-90});ok(!D.called,"A layoutChanged event wasn't triggered");E.set({sourceAngle:0,targetAngle:180});ok(D.called,"A layoutChanged event was triggered")});test("Triggers a layoutChanged event when transition target changes",function(){var E=sinon.spy(),D=this.workflowModel.addStatus(),F=this.workflowModel.addTransition({target:D});this.workflowModel.bind("layoutChanged",E);F.set("target",D);ok(!E.called,"A layoutChanged event wasn't triggered");F.set("target",this.workflowModel.addStatus());ok(E.called,"A layoutChanged event was triggered")});test("Triggers a layoutChanged event when transition model is destroyed",function(){var D=sinon.spy(),E=this.workflowModel.addTransition({actionId:1});this.workflowModel.bind("layoutChanged",D);E.destroy();ok(D.called,"A layoutChanged event was triggered")});test("statusHasGlobalTransition() returns false when status has no transitions",function(){var D=new A({id:1});this.workflowModel.reset({statuses:[D]});ok(!this.workflowModel.statusHasGlobalTransition(D),"Should return false when no transitions")});test("statusHasGlobalTransition() returns false when status has only normal transitions",function(){var H,D,F,E,G;D=new A({id:1});F=new A({id:2});E=new A({id:3});H=new B({actionId:1,source:E,target:D});G=new B({actionId:2,source:E,target:F});this.workflowModel.reset({statuses:[D,F,E],transitions:[H,G]});ok(!this.workflowModel.statusHasGlobalTransition(F),"Should return false when only normal transitions")});test("statusHasGlobalTransition() returns true when status has only global transition",function(){var E,D;D=new A({id:1});E=new B({actionId:1,target:D,globalTransition:true});this.workflowModel.reset({statuses:[D],transitions:[E]});ok(this.workflowModel.statusHasGlobalTransition(D),"Should return true when only a global transition")});test("statusHasGlobalTransition() returns true when status has global transition and normal transitions",function(){var I,D,G,F,E,H;D=new A({id:1});F=new A({id:2});E=new A({id:3});I=new B({actionId:1,source:E,target:D});H=new B({actionId:2,source:E,target:F});G=new B({actionId:3,target:F,globalTransition:true});this.workflowModel.reset({statuses:[D,F,E],transitions:[I,H,G]});ok(this.workflowModel.statusHasGlobalTransition(F),"Should return true when normal transitions and a global transition")});test("updateTransitionTargets sets the passed step on all transitions with the passed action ID",function(){var D=this.workflowModel.addStatus({stepId:1}),F=this.workflowModel.addTransition({actionId:2}),E=this.workflowModel.addTransition({actionId:2});this.sandbox.spy(F,"setTarget");this.sandbox.spy(E,"setTarget");this.workflowModel.updateTransitionTargets({targetAngle:0,targetStepId:1,transition:F});equal(F.setTarget.callCount,1,"setTarget of the first transition was called");equal(F.setTarget.args[0][0],D,"It was passed the correct target");equal(F.setTarget.args[0][1],0,"It was passed the correct target angle");equal(E.setTarget.callCount,1,"setTarget of the second transition was called");equal(E.setTarget.args[0][0],D,"It was passed the correct target");ok(!E.setTarget.args[0][1],"It was passed the correct target angle")});test("updateTransitionSource sets the new source",function(){var D=this.workflowModel.addStatus({stepId:1}),E=this.workflowModel.addTransition({actionId:2});this.sandbox.spy(E,"setSource");this.workflowModel.updateTransitionSource({sourceAngle:0,sourceStepId:1,transition:E});equal(E.setSource.callCount,1,"setSource of the first transition was called");equal(E.setSource.args[0][0],D,"It was passed the correct source");equal(E.setSource.args[0][1],0,"It was passed the correct source angle")})});