define("workflow-designer/permissions-model", [
    "workflow-designer/backbone"
], function(
    Backbone
) {
    /**
     * @classdesc
     * Permission options (like editing transition options
     *
     * @constructs
     * @extends Backbone.Model
     */
    return Backbone.Model.extend({
        defaults: {
            administrator: false,
            editPropertyOptions: false,
            selectScreenOnTransition: false,
            createStatus: false,      // whether the user should be able to create status
            editStatus: false,        // whether the user should be able to edit status
            deleteStatus: false,      // whether the user should be able to delete status
            editWorkflow: false
        }
    });
});
