define("workflow-designer/looped-transition-container-model", [
    "workflow-designer/backbone",
    "workflow-designer/underscore"
], function(
    Backbone,
    _
) {
    /**
     * @class JIRA.WorkflowDesigner.LoopedTransitionContainerModel
     * @classdesc A looped transition container in a JIRA workflow.
     * @extends Backbone.Model
     */
    return Backbone.Model.extend(
    /** @lends JIRA.WorkflowDesigner.StatusModel# */
    {
        defaults: {
            x: null,
            y: null
        },

        /**
         * @return {boolean} Whether the status has x and y coordinates.
         */
        hasCoordinates: function () {
            var x = this.get("x"),
                y = this.get("y");

            return _.isNumber(x) && _.isNumber(y);
        }
    });
});

AJS.namespace("JIRA.WorkflowDesigner.LoopedTransitionContainerModel", null, require("workflow-designer/looped-transition-container-model"));