AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var PositionOnParentBoundsLocator = require("workflow-designer/layout/locator/position-on-parent-bounds-locator");
    var Direction = require("workflow-designer/direction");

    module("PositionOnParentBoundsLocator", {
        assertRelocation: function (side, bias, expectedX, expectedY) {
            var locator,
                parentBoundingBox = new draw2d.geo.Rectangle(0, 0, 100, 100),
                target = {setPosition: sinon.spy()};

            locator = new PositionOnParentBoundsLocator({
                parent: {
                    getBoundingBox: function () {
                        return parentBoundingBox;
                    }
                },
                side: side,
                bias: bias
            });

            locator.relocate(0, target);
            equal(target.setPosition.callCount, 1, "The target's setPosition() method was called");
            ok(target.setPosition.calledWithExactly(expectedX, expectedY), "It was passed the correct x and y coordinates");
        }
    });

    test("relocate()", function () {
        this.assertRelocation(Direction.UP, 0.5, 50, 0);
        this.assertRelocation(Direction.DOWN, 0.5, 50, 100);
        this.assertRelocation(Direction.LEFT, 0.5, 0, 50);
        this.assertRelocation(Direction.RIGHT, 0.5, 100, 50);
    });

});
