AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-loader",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var RoundedManhattanConnectionRouter = require("workflow-designer/layout/connection/rounded-manhattan-connection-router");
    var draw2d = require("workflow-designer/draw-2d");
    var TestMocks = require("workflow-designer/test-mocks");
    var jQuery = require("jquery");

    module("RoundedManhattanConnectionRouter", {
        assertSVGPathString: function (connection, expected) {
            equal(connection.svgPathString.replace(/,/g, " "), expected,
                "The connection's SVG path string was correct");
        },

        createConnection: function (points) {
            var connection = new draw2d.Connection();

            _.each(points, function (point) {
                point = this.createPoint(point);
                connection.addPoint(point);
            }, this);

            return _.extend(connection, {
                getEndPoint: jQuery.noop,
                getSource: TestMocks.port,
                getStartPoint: jQuery.noop,
                getTarget: TestMocks.port
            });
        },

        createPoint: function (components) {
            var point = new draw2d.geo.Point(0, 0);
            draw2d.geo.Point.apply(point, components);
            return point;
        },

        setup: function () {
            this.router = new RoundedManhattanConnectionRouter();
            this.router._route = jQuery.noop;
        }
    });

    test("route()", function () {
        var connection = this.createConnection([
            [0, 0],
            [0, 100],
            [100, 100],
            [100, 200]
        ]);

        this.router.route(connection);
        this.assertSVGPathString(connection, [
            "M 0 0",
            "L 0 0",
            "S 0 0 0 0",
            "L 0 95",
            "S 0 100 5 100",
            "L 95 100",
            "S 100 100 100 105",
            "L 100 200",
            "S 100 200 100 200"
        ].join(" "));
    });

    test("route() reduces the corner radius for short line segments", function () {
        var connection = this.createConnection([
            [0, 0],
            [0, 100],
            [4, 100],
            [4, 200]
        ]);

        this.router.route(connection);
        this.assertSVGPathString(connection, [
            "M 0 0",
            "L 0 0",
            "S 0 0 0 0",
            "L 0 98",
            "S 0 100 2 100", // 2 point radius instead of 5
            "L 2 100",
            "S 4 100 4 102",
            "L 4 200",
            "S 4 200 4 200"
        ].join(" "));
    });

    test("route() two points", function () {
        var connection = this.createConnection([
            [0, 0],
            [100, 100]
        ]);

        this.router.route(connection);
        this.assertSVGPathString(connection, [
            "M 0 0",
            "L 0 0",
            "S 0 0 0 0",
            "L 100 100",
            "S 100 100 100 100"
        ].join(" "));
    });

});
