AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var draw2d = require("workflow-designer/draw-2d");
    var GappedConnection = require("workflow-designer/layout/connection/gapped-connection");
    var Direction = require("workflow-designer/direction");
    
    module("GappedConnection", {
        setup: function () {
            this.sandbox = sinon.sandbox.create();

            this.parentSetEndPoint = this.sandbox.stub(draw2d.Connection.prototype, "setEndPoint");
            this.parentSetStartPoint = this.sandbox.stub(draw2d.Connection.prototype, "setStartPoint");
            this.sandbox.stub(draw2d.Connection.prototype, "getEndPoint").returns(new draw2d.geo.Point(100, 100));
            this.sandbox.stub(draw2d.Connection.prototype, "getStartPoint").returns(new draw2d.geo.Point(100, 100));

            this.connection = new GappedConnection(10, 10);

            this.connectionDirectionStub = this.sandbox.stub();
            this.sandbox.stub(this.connection, "getTarget").returns({
                getConnectionDirection: this.connectionDirectionStub
            });
            this.sandbox.stub(this.connection, "getSource").returns({
                getConnectionDirection: this.connectionDirectionStub
            });
        },

        teardown: function () {
            this.sandbox.restore();
        },

        assertSetEndPointGap: function (direction, expected, msg) {
            this.parentSetEndPoint.reset();
            this.connectionDirectionStub.returns(direction);
            this.connection.setEndPoint(100, 100);
            deepEqual(this.parentSetEndPoint.lastCall.args, expected, msg);
        },

        assertSetStartPointGap: function (direction, expected, msg) {
            this.parentSetStartPoint.reset();
            this.connectionDirectionStub.returns(direction);
            this.connection.setStartPoint(100, 100);
            deepEqual(this.parentSetStartPoint.lastCall.args, expected, msg);
        },

        assertGetEndPointGap: function (direction, expected, msg) {
            this.connectionDirectionStub.returns(direction);
            deepEqual(this.connection.getEndPoint().getComponents(), expected, msg);
        },

        assertGetStartPointGap: function (direction, expected, msg) {
            this.connectionDirectionStub.returns(direction);
            deepEqual(this.connection.getStartPoint().getComponents(), expected, msg);
        }

    });

    test("setEndPoint() should compute the endpoint position using the gap", function () {
        this.assertSetEndPointGap(Direction.UP, [100, 90], "Point for up direction");
        this.assertSetEndPointGap(Direction.RIGHT, [110, 100], "Point for right direction");
        this.assertSetEndPointGap(Direction.DOWN, [100, 110], "Point for down direction");
        this.assertSetEndPointGap(Direction.LEFT, [90, 100], "Point for left direction");

        this.connection.isMoving = true;
        this.assertSetEndPointGap(Direction.LEFT, [100, 100], "Gap is not added if the connection is moving");
    });

    test("setStartPoint() should compute the startpoint position using the gap", function () {
        this.assertSetStartPointGap(Direction.UP, [100, 90], "Point for up direction");
        this.assertSetStartPointGap(Direction.RIGHT, [110, 100], "Point for right direction");
        this.assertSetStartPointGap(Direction.DOWN, [100, 110], "Point for down direction");
        this.assertSetStartPointGap(Direction.LEFT, [90, 100], "Point for left direction");

        this.connection.isMoving = true;
        this.assertSetStartPointGap(Direction.LEFT, [100, 100], "Gap is not added if the connection is moving");
    });

    test("getEndPoint() should compute the endpoint using the gap", function () {
        this.assertGetEndPointGap(Direction.UP, [100, 90], "Point for up direction");
        this.assertGetEndPointGap(Direction.RIGHT, [110, 100], "Point for right direction");
        this.assertGetEndPointGap(Direction.DOWN, [100, 110], "Point for down direction");
        this.assertGetEndPointGap(Direction.LEFT, [90, 100], "Point for left direction");

        this.connection.isMoving = true;
        this.assertGetEndPointGap(Direction.LEFT, [100, 100], "Gap is not added if the connection is moving");
    });

    test("getStartPoint() should compute the endpoint using the gap", function () {
        this.assertGetStartPointGap(Direction.UP, [100, 90], "Point for up direction");
        this.assertGetStartPointGap(Direction.RIGHT, [110, 100], "Point for right direction");
        this.assertGetStartPointGap(Direction.DOWN, [100, 110], "Point for down direction");
        this.assertGetStartPointGap(Direction.LEFT, [90, 100], "Point for left direction");

        this.connection.isMoving = true;
        this.assertGetStartPointGap(Direction.LEFT, [100, 100], "Gap is not added if the connection is moving");
    });

});
