define("workflow-designer/last-saved-by/view", [
    "workflow-designer/last-saved-by/template",
    "workflow-designer/backbone"
], function(
    Template,
    Backbone
) {
    "use strict";

    return Backbone.Marionette.ItemView.extend({
        className: "last-saved-by-message",
        tagName: "span",
        template: Template.ui,

        modelEvents: {
            "change": "render"
        },

        ui: {
            time: "time"
        },

        onRender: function() {
            this.ui.time.livestamp();
        }
    });
});
