AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-last-saved-by"],function(){var B=require("jquery");var A=require("workflow-designer/underscore");module("LastSavedByView",{setup:function(){this.sandbox=sinon.sandbox.create();this.context=AJS.test.mockableModuleContext();this.sandbox.stub(B.fn,"livestamp");this.container=B("#qunit-fixture");this.model=this.createModel()},teardown:function(){this.sandbox.restore()},createView:function(D){var E=this.context.require("workflow-designer/last-saved-by/view");var C=new E(A.extend({model:this.model},D));this.container.empty().append(C.render().el);return C},createModel:function(C){var D=this.context.require("workflow-designer/last-saved-by/model");return new D(A.extend({},C||{}))},mockUser:function(){this.model.set("currentUserName","bob")},isWaitIconPresent:function(){return this.container.find(".aui-icon-wait.last-saved-by__icon-wait:not(.aui-icon-small.aui-iconfont-wait)").length>0},isSuccessIconPresent:function(){return this.container.find(".aui-icon.aui-icon-small.aui-iconfont-approve.last-saved-by__icon-approve").length>0},isFailureIconPresent:function(){return this.container.find(".aui-icon.aui-icon-small.aui-iconfont-error.last-saved-by__icon-error").length>0},isIconNotPresent:function(){return this.container.find(".aui-icon").length===0},assertLastSavedByNotEmpty:function(){var C=this.container.find(".last-saved-by-message");notEqual(C.text(),"","Last-saved-by message should not be empty.")},assertLastSavedByIsEmpty:function(){var C=this.container.find(".last-saved-by-message");equal(C.text(),"","Last-saved-by message should be empty.")}});test("Should display last-saved-by message",function(){this.createView();this.model.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});this.model.set("updatedDate",new Date().getTime());this.assertLastSavedByNotEmpty()});test("Should call `livestamp` on view render",function(){sinon.assert.notCalled(B.fn.livestamp);this.createView();sinon.assert.calledOnce(B.fn.livestamp);this.model.set({updateAuthor:{userName:"bob",displayName:"Bob Dude"},updatedDate:new Date().getTime()});sinon.assert.calledTwice(B.fn.livestamp)});test("Should be able to display wait icon",function(){this.createView();this.model.set({updateAuthor:{userName:"bob",displayName:"Bob Dude"},updatedDate:new Date().getTime(),icon:"wait"});ok(this.isWaitIconPresent())});test("Should be able to display success icon",function(){this.createView();this.model.set({updateAuthor:{userName:"bob",displayName:"Bob Dude"},updatedDate:new Date().getTime(),icon:"approve"});ok(this.isSuccessIconPresent())});test("Should be able to display failure icon",function(){this.createView();this.model.set({updateAuthor:{userName:"bob",displayName:"Bob Dude"},updatedDate:new Date().getTime(),icon:"error"});ok(this.isFailureIconPresent())});test("Should not display any icon when $icon variable was not provided",function(){this.createView();this.model.set({updateAuthor:{userName:"bob",displayName:"Bob Dude"},updatedDate:new Date().getTime()});ok(this.isIconNotPresent())});test("Should display 'Saving changes...' when the current state is 'pending-slow'",function(){var C;this.mockUser();this.createView();this.model.set({updateAuthor:{userName:"bob",displayName:"Bob Dude"},updatedDate:new Date().getTime(),state:"pending-slow"});C=this.container.find(".last-saved-by-message");equal(C.text(),"workflow.designer.last.saved.by.pending")});test("Last-saved-by message displayed when both updateAuthor and updatedDate defined",function(){var C;this.mockUser();this.createView();this.model.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});this.model.set("updatedDate",new Date().getTime());C=this.container.find(".last-saved-by-message");equal(C.text(),"workflow.designer.last.edited.by.you","Last-saved-by message should be displayed.")});test("Last-saved-by message not displayed when lastUpdater defined and updatedDate not defined",function(){this.mockUser();this.createView();this.model.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});this.assertLastSavedByIsEmpty()});test("Last-saved-by message not displayed when updateAuthor not defined and updatedDate defined",function(){this.mockUser();this.createView();this.model.set("updatedDate",new Date().getTime());this.assertLastSavedByIsEmpty()});test("Last-saved-by message not displayed when both updateAuthor and updatedDate not defined",function(){this.mockUser();this.createView();this.assertLastSavedByIsEmpty()});test("'You' last-saved-by message should be displayed if current user is same as last updater",function(){var C;this.mockUser();this.createView();this.model.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});this.model.set("updatedDate",new Date().getTime());C=this.container.find(".last-saved-by-message");equal(C.text(),"workflow.designer.last.edited.by.you","Last-saved-by message should be displayed.")});test("'User' last-saved-by message should be displayed if current user is not same as last updater",function(){this.sandbox.stub(AJS,"format");this.mockUser();this.createView();this.model.set("updateAuthor",{userName:"jim",displayName:"Jim Dude"});this.model.set("updatedDate",new Date().getTime());sinon.assert.calledWith(AJS.format,"workflow.designer.last.edited.by.other.user","Jim Dude")});test("Last-saved-by message updated when model updated",function(){this.sandbox.stub(AJS,"format");this.mockUser();this.createView();this.model.set("updateAuthor",{userName:"bob",displayName:"Bob Dude"});this.model.set("updatedDate",new Date().getTime());sinon.assert.calledWith(AJS.format,"workflow.designer.last.edited.by.you");this.model.set("updateAuthor",{userName:"jim",displayName:"Jim Man"});sinon.assert.calledWith(AJS.format,"workflow.designer.last.edited.by.other.user","Jim Man")})});