define("workflow-designer/last-saved-by/model", [
    "workflow-designer/backbone"
], function(
    Backbone
) {
    "use strict";

    return Backbone.Model.extend({
        defaults: function() {
            return {
                /**
                 * A name of the icon which will be displayed next to the message.
                 */
                icon: '',
                /**
                 * Indicates which message should be displayed.
                 * Possible values: pending, pending-slow, success, failure
                 */
                state: '',
                /**
                 * A username of currently logged in user.
                 */
                currentUserName: '',
                /**
                 * Timestamp of the last successful save [ms].
                 */
                updatedDate: 0,
                /**
                 * A user who performs the last successful save.
                 * @type {{displayName: '', userName: ''}}
                 */
                updateAuthor: null
            };
        }
    });
});
