AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-io",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var WorkflowTransitionsAJAXManager = require("workflow-designer/io/ajax/workflow-transitions-ajax-manager");
    var TestUtilities = require("workflow-designer/test-utilities");
    var contextPath = require("wrm/context-path");
    
    module("WorkflowTransitionsAJAXManager", {
        setup: function () {
            this.sandbox = sinon.sandbox.create({useFakeServer: true});
            this.workflowTransitionsAJAXManager = WorkflowTransitionsAJAXManager;
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("addCommonTransition() resolves the returned deferred on success", function () {
        var deferred, expectedRequestBody, requestBody;

        deferred = this.workflowTransitionsAJAXManager.addCommonTransition({
            invalidOption: "invalid",
            sourceStatusId: "open",
            transitionId: 1,
            workflowName: "Workflow"
        });

        expectedRequestBody = {
            sourceStatusId: "open",
            transitionId: "1",
            workflowName: "Workflow"
        };

        this.sandbox.server.respondWith(contextPath() + "/rest/workflowDesigner/latest/workflows/transitions/common", [200, {}, ""]);
        this.sandbox.server.respond();

        requestBody = TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);
        deepEqual(requestBody, expectedRequestBody, "The request body was correct.");
        equal(deferred.state(), "resolved", "The returned deferred was resolved.");
    });

    test("addCommonTransition() rejects the returned deferred on error", function () {
        var deferred;

        deferred = this.workflowTransitionsAJAXManager.addCommonTransition({
            sourceStatusId: "open",
            transitionId: 1,
            workflowName: "Workflow"
        });

        TestUtilities.respondWithErrorAndAssertRejected(
            deferred, "/rest/workflowDesigner/latest/workflows/transitions/common", this.sandbox.server);
    });

    test("addTransition() provides new transition ID", function () {
        var actualRequestObject,
            deferred,
            sentRequestObject;

        sentRequestObject = {
            name: "name",
            description: "description",
            sourceStepId: "1",
            targetStepId: "2",
            workflowName: "Workflow"
        };
        deferred = this.workflowTransitionsAJAXManager.addTransition(sentRequestObject);

        this.sandbox.server.respondWith(contextPath() + "/rest/workflowDesigner/latest/workflows/transitions", [200, {}, "100"]);
        this.sandbox.server.respond();

        actualRequestObject = TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);
        deepEqual(actualRequestObject, sentRequestObject, "The request body for creates was correct.");

        equal(deferred.state(), "resolved", "The returned deferred was resolved.");

        deferred.done(function (actionId) {
            equal(actionId, 100, "It was resolved with correct data");
        });
    });

    test("addTransition() rejects the returned deferred on error", function () {
        var deferred;

        deferred = this.workflowTransitionsAJAXManager.addTransition({
            description: "description",
            name: "name",
            screenId: 1,
            sourceStepId: 1,
            targetStepId: 2,
            workflowName: "Workflow"
        });

        TestUtilities.respondWithErrorAndAssertRejected(
            deferred, "/rest/workflowDesigner/latest/workflows/transitions", this.sandbox.server);
    });

    test("deleteTransition() resolves deferred result on success", function () {
        var actualRequestObject,
            deferred,
            sentRequestObject;

        sentRequestObject = {
            transitionId: "100",
            sourceStepId: "1",
            workflowName: "Workflow"
        };
        deferred = this.workflowTransitionsAJAXManager.deleteTransition(sentRequestObject);

        this.sandbox.server.respondWith(contextPath() + "/rest/workflowDesigner/latest/workflows/transitions", [200, {}, ""]);
        this.sandbox.server.respond();

        actualRequestObject = TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);
        deepEqual(actualRequestObject, sentRequestObject, "The request body for creates was correct.");
        equal(deferred.state(), "resolved", "The returned deferred was resolved.");
    });

    test("deleteTransition() rejects the returned deferred on error", function () {
        var deferred;

        deferred = this.workflowTransitionsAJAXManager.deleteTransition({
            transitionId: 100,
            sourceStepId: 1,
            workflowName: "Workflow"
        });

        TestUtilities.respondWithErrorAndAssertRejected(
            deferred, "/rest/workflowDesigner/latest/workflows/transitions", this.sandbox.server);
    });

    test("updateTransition() resolves deferred result on success", function () {
        var actualRequestObject,
            deferred,
            sentRequestObject;

        sentRequestObject = {
            transitionId: "100",
            name: "name",
            description: "description",
            workflowName: "Workflow",
            sourceStepId: "1",
            screenId: "1"
        };

        deferred = this.workflowTransitionsAJAXManager.updateTransition(sentRequestObject);
        this.sandbox.server.respondWith(contextPath() + "/rest/workflowDesigner/latest/workflows/transitions", [200, {}, ""]);
        this.sandbox.server.respond();

        actualRequestObject = TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);
        deepEqual(actualRequestObject, sentRequestObject, "The request body for update was correct.");
        equal(deferred.state(), "resolved", "The returned deferred was resolved.");
    });

    test("updateTransition() rejects the returned deferred on error", function () {
        var deferred = this.workflowTransitionsAJAXManager.updateTransition({
            transitionId: 100,
            name: "name",
            description: "description",
            workflowName: "Workflow",
            sourceStepId: 1,
            screenId: 1
        });

        TestUtilities.respondWithErrorAndAssertRejected(
            deferred, "/rest/workflowDesigner/latest/workflows/transitions", this.sandbox.server);
    });

    test("updateTransitionTarget() resolves deferred result on success", function () {
        var actualRequestObject,
            deferred,
            sentRequestObject;

        sentRequestObject = {
            transitionId: "100",
            workflowName: "Workflow",
            targetStatusId: "1"
        };

        deferred = this.workflowTransitionsAJAXManager.updateTransitionTarget(sentRequestObject);
        this.sandbox.server.respondWith(contextPath() + "/rest/workflowDesigner/latest/workflows/transitions/target", [200, {}, ""]);
        this.sandbox.server.respond();

        actualRequestObject = TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);
        deepEqual(actualRequestObject, sentRequestObject, "The request body for update was correct.");
        equal(deferred.state(), "resolved", "The returned deferred was resolved.");
    });

    test("updateTransitionTarget() rejects the returned deferred on error", function () {
        var deferred = this.workflowTransitionsAJAXManager.updateTransitionTarget({
            transitionId: "100",
            workflowName: "Workflow",
            targetStatusId: "1"
        });

        TestUtilities.respondWithErrorAndAssertRejected(
            deferred, "/rest/workflowDesigner/latest/workflows/transitions/target", this.sandbox.server);
    });

    test("updateTransitionSource() resolves deferred result on success", function () {
        var actualRequestObject,
            deferred,
            sentRequestObject;

        sentRequestObject = {
            transitionId: "100",
            workflowName: "Workflow",
            newSourceStatusId: "1",
            originalSourceStatusId: "2"
        };

        deferred = this.workflowTransitionsAJAXManager.updateTransitionSource(sentRequestObject);
        this.sandbox.server.respondWith(contextPath() + "/rest/workflowDesigner/latest/workflows/transitions/source", [200, {}, ""]);
        this.sandbox.server.respond();

        actualRequestObject = TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);
        deepEqual(actualRequestObject, sentRequestObject, "The request body for update was correct.");
        equal(deferred.state(), "resolved", "The returned deferred was resolved.");
    });

    test("updateTransitionTarget() rejects the returned deferred on error", function () {
        var deferred = this.workflowTransitionsAJAXManager.updateTransitionSource({
            transitionId: "100",
            workflowName: "Workflow",
            newSourceStatusId: "1",
            originalSourceStatusId: "2"
        });

        TestUtilities.respondWithErrorAndAssertRejected(
            deferred, "/rest/workflowDesigner/latest/workflows/transitions/source", this.sandbox.server);
    });

});
