AJS.test.require(["com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-io","com.atlassian.jira.plugins.jira-workflow-designer:test-resources"],function(){var C=require("workflow-designer/io/ajax/workflow-statuses-ajax-manager");var E=require("workflow-designer/io/ajax/statuses-ajax-manager");var D=require("workflow-designer/io/workflow-data-reader");var A=require("workflow-designer/test-utilities");var B=require("wrm/context-path");module("WorkflowStatusesAJAXManager",{setup:function(){this.addStatusURL=B()+"/rest/workflowDesigner/latest/workflows/statuses";this.createStatusURL=B()+"/rest/workflowDesigner/latest/workflows/statuses/create";this.sandbox=sinon.sandbox.create({useFakeServer:true});this.workflowDataReaderStub=this.sandbox.stub(D,"read");this.workflowStatusesAJAXManager=C;this.triggerStub=this.sandbox.stub(this.workflowStatusesAJAXManager,"trigger")},teardown:function(){this.sandbox.restore();this.workflowStatusesAJAXManager.reset()}});test("addStatus()",function(){var H,I,G,F={};sinon.assert.notCalled(this.triggerStub);H=this.workflowStatusesAJAXManager.addStatus({createGlobalTransition:true,statusId:"Open",workflowName:"Workflow"});sinon.assert.calledOnce(this.triggerStub);this.workflowDataReaderStub.returns(F);this.sandbox.server.respondWith(this.addStatusURL,[200,{},"{}"]);this.sandbox.server.respond();G={createGlobalTransition:"true",statusId:"Open",workflowName:"Workflow"};I=A.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);deepEqual(I,G,"The request's body was correct");equal(this.workflowDataReaderStub.callCount,1,"The AJAX response was passed to WorkflowDataReader.read()");deepEqual(this.workflowDataReaderStub.args[0],[{}],"It was passed the correct arguments");equal(H.state(),"resolved","The returned deferred was resolved.");H.done(function(J){ok(J===F,"It was resolved with the output of WorkflowDataReader.read()")})});test("addStatus() rejects the returned deferred on error",function(){var F;sinon.assert.notCalled(this.triggerStub);F=this.workflowStatusesAJAXManager.addStatus({createGlobalTransition:true,statusId:"Closed",workflowName:"Workflow"});sinon.assert.calledOnce(this.triggerStub);this.sandbox.server.respondWith(this.addStatusURL,[400,{},"No deal."]);this.sandbox.server.respond();equal(F.state(),"rejected","The returned deferred was rejected");F.fail(function(G){equal(G,"No deal.","It was rejected with the error message.")})});test("createStatus() with create global transition flag",function(){var I,H,G={},K,F=this.sandbox.spy(E,"reset"),J=this.sandbox.spy(C,"reset");this.sandbox.server.respondWith(B()+"/rest/workflowDesigner/latest/workflows/statuses",[200,{},""]);this.sandbox.server.respond();sinon.assert.notCalled(this.triggerStub);I=this.workflowStatusesAJAXManager.createStatus({createGlobalTransition:true,description:"Description",name:"Status",statusCategoryId:"1",workflowName:"Workflow"});sinon.assert.calledOnce(this.triggerStub);this.workflowDataReaderStub.returns(G);this.sandbox.server.respondWith(this.createStatusURL,[200,{},"{}"]);this.sandbox.server.respond();K=A.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);H={createGlobalTransition:"true",description:"Description",name:"Status",statusCategoryId:"1",workflowName:"Workflow"};deepEqual(K,H,"The request body for create was correct.");equal(this.workflowDataReaderStub.callCount,1,"The AJAX response was passed to WorkflowDataReader.read()");deepEqual(this.workflowDataReaderStub.args[0],[{}],"It was passed the correct arguments");equal(I.state(),"resolved","The returned deferred was resolved.");equal(F.callCount,1,"StatusesAJAXManager.reset() was called");equal(J.callCount,1,"WorkflowStatusesAJAXManagerResetSpy.reset() was called");I.done(function(L){ok(L===G,"It was resolved with the output of WorkflowDataReader.read()")})});test("createStatus() rejects the returned deferred on error",function(){var F;sinon.assert.notCalled(this.triggerStub);F=this.workflowStatusesAJAXManager.createStatus({description:"A plain old status.",name:"Status",workflowName:"Workflow"});sinon.assert.calledOnce(this.triggerStub);this.sandbox.server.respondWith(this.createStatusURL,[400,{},"No"]);this.sandbox.server.respond();equal(F.state(),"rejected","The returned deferred was rejected");F.fail(function(G){equal(G,"No","It was rejected with the error message")})});test("removeStatus() resolves deferred result on success and has correct request body",function(){var G,F,H;sinon.assert.notCalled(this.triggerStub);G=this.workflowStatusesAJAXManager.removeStatus({statusId:100,workflowName:"Workflow"});sinon.assert.calledOnce(this.triggerStub);this.sandbox.server.respondWith(B()+"/rest/workflowDesigner/latest/workflows/statuses",[200,{},""]);this.sandbox.server.respond();F={statusId:"100",workflowName:"Workflow"};H=A.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);deepEqual(H,F,"The request body matches the arguments sent to identify a status for removal");equal(G.state(),"resolved","The returned deferred was resolved.")});test("removeStatus() rejects the returned deferred on error",function(){var F;sinon.assert.notCalled(this.triggerStub);F=this.workflowStatusesAJAXManager.removeStatus({statusId:100,workflowName:"Workflow"});sinon.assert.calledOnce(this.triggerStub);A.respondWithErrorAndAssertRejected(F,"/rest/workflowDesigner/latest/workflows/statuses",this.sandbox.server)});test("updateStatus() resolves deferred result on success",function(){var H,F,G;G={description:"New description!",name:"New Name",statusCategoryId:"1",statusId:"100",workflowName:"Workflow"};sinon.assert.notCalled(this.triggerStub);F=this.workflowStatusesAJAXManager.updateStatus({description:"New description!",name:"New Name",someUnknownParameter:true,statusCategoryId:"1",statusId:"100",workflowName:"Workflow"});sinon.assert.calledOnce(this.triggerStub);this.sandbox.server.respondWith(B()+"/rest/workflowDesigner/latest/workflows/statuses",[200,{},""]);this.sandbox.server.respond();H=A.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);deepEqual(H,G,"The request body for update was correct.");equal(F.state(),"resolved","The returned deferred was resolved.")});test("updateStatus() rejects the returned deferred on error",function(){sinon.assert.notCalled(this.triggerStub);var F=this.workflowStatusesAJAXManager.updateStatus({transitionId:100,name:"name",description:"description",workflowName:"Workflow"});sinon.assert.calledOnce(this.triggerStub);A.respondWithErrorAndAssertRejected(F,"/rest/workflowDesigner/latest/workflows/statuses",this.sandbox.server)});test("getStatuses()",function(){sinon.assert.notCalled(this.triggerStub);var H=this.workflowStatusesAJAXManager.getStatuses({workflowName:"workflow name"}),G=[{name:"Open"},{name:"Closed"}],F=B()+"/rest/workflowDesigner/latest/workflows/statuses";sinon.assert.notCalled(this.triggerStub);this.sandbox.server.respondWith(new RegExp(F),JSON.stringify(G));this.sandbox.server.respond();equal(this.sandbox.server.requests.length,1,"An AJAX request was made to retrieve the statuses");equal(H.state(),"resolved","The returned deferred was resolved");H.done(function(I){deepEqual(I,G,"It was resolved with status information")});H=this.workflowStatusesAJAXManager.getStatuses({workflowName:"workflow name"});sinon.assert.notCalled(this.triggerStub);equal(this.sandbox.server.requests.length,1,"Subsequent calls don't result in an AJAX request");ok(this.sandbox.server.requests[0].url.indexOf("workflowName=workflow+name")!==-1);equal(H.state(),"resolved","The returned deferred is resolved immediately");H.done(function(I){deepEqual(I,G,"It is resolved with status information")});this.workflowStatusesAJAXManager.reset();H=this.workflowStatusesAJAXManager.getStatuses({workflowName:"workflow name"});this.sandbox.server.respond();sinon.assert.notCalled(this.triggerStub);equal(this.sandbox.server.requests.length,2,"reset() clears the cached response");equal(H.state(),"resolved","The returned deferred was resolved")});test("getStatuses() rejects the returned deferred on error",function(){sinon.assert.notCalled(this.triggerStub);var G=this.workflowStatusesAJAXManager.getStatuses({workflowName:"workflow name"}),F=B()+"/rest/workflowDesigner/latest/workflows/statuses";sinon.assert.notCalled(this.triggerStub);this.sandbox.server.respondWith(new RegExp(F),[400,{},"No deal."]);this.sandbox.server.respond();equal(G.state(),"rejected","The returned deferred was rejected");G.fail(function(H){equal(H,"No deal.","It was rejected with the error message.")})});test("validateRemoveStatus() should not trigger 'sync' event",function(){sinon.assert.notCalled(this.triggerStub);this.workflowStatusesAJAXManager.validateRemoveStatus({statusId:"Open",workflowName:"Workflow"});sinon.assert.notCalled(this.triggerStub)})});