AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-io",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var WorkflowLoopedTransitionsAJAXManager = require("workflow-designer/io/ajax/workflow-looped-transitions-ajax-manager");
    var TestUtilities = require("workflow-designer/test-utilities");
    var contextPath = require("wrm/context-path");
    
    module("WorkflowLoopedTransitionsAJAXManager", {
        setup: function () {
            this.sandbox = sinon.sandbox.create({useFakeServer: true});
            this.workflowLoopedTransitionsAJAXManager = WorkflowLoopedTransitionsAJAXManager;
        },

        teardown: function () {
            this.sandbox.restore();
        }
    });

    test("addLoopedTransition() provides new transition ID on success", function () {
        var actualRequestObject,
            deferred,
            sentRequestObject;

        sentRequestObject = {
            name: "name",
            description: "description",
            workflowName: "Workflow"
        };
        deferred = this.workflowLoopedTransitionsAJAXManager.addLoopedTransition(sentRequestObject);

        this.sandbox.server.respondWith(contextPath() + "/rest/workflowDesigner/latest/workflows/loopedTransitions", [200, {}, "100"]);
        this.sandbox.server.respond();

        actualRequestObject = TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);
        deepEqual(actualRequestObject, sentRequestObject, "The request body for creates was correct.");

        equal(deferred.state(), "resolved", "The returned deferred was resolved.");

        deferred.done(function (actionId) {
            equal(actionId, 100, "It was resolved with correct data");
        });
    });

    test("addLoopedTransition() rejects the returned deferred on error", function () {
        var deferred;

        deferred = this.workflowLoopedTransitionsAJAXManager.addLoopedTransition({
            description: "description",
            name: "name",
            screenId: 1,
            workflowName: "Workflow"
        });

        TestUtilities.respondWithErrorAndAssertRejected(
            deferred, "/rest/workflowDesigner/latest/workflows/loopedTransitions", this.sandbox.server);
    });

    test("deleteLoopedTransition() resolves deferred result on success", function () {
        var actualRequestObject,
            deferred,
            sentRequestObject;

        sentRequestObject = {
            transitionId: "100",
            workflowName: "Workflow"
        };
        deferred = this.workflowLoopedTransitionsAJAXManager.deleteLoopedTransition(sentRequestObject);

        this.sandbox.server.respondWith(contextPath() + "/rest/workflowDesigner/latest/workflows/loopedTransitions", [200, {}, ""]);
        this.sandbox.server.respond();

        actualRequestObject = TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);
        deepEqual(actualRequestObject, sentRequestObject, "The request body for creates was correct.");
        equal(deferred.state(), "resolved", "The returned deferred was resolved.");
    });

    test("deleteTransition() rejects the returned deferred on error", function () {
        var deferred;

        deferred = this.workflowLoopedTransitionsAJAXManager.deleteLoopedTransition({
            transitionId: 100,
            workflowName: "Workflow"
        });

        TestUtilities.respondWithErrorAndAssertRejected(
            deferred, "/rest/workflowDesigner/latest/workflows/loopedTransitions", this.sandbox.server);
    });

    test("updateLoopedTransition() resolves deferred result on success", function () {
        var actualRequestObject,
            deferred,
            sentRequestObject;

        sentRequestObject = {
            transitionId: "100",
            name: "name",
            description: "description",
            workflowName: "Workflow",
            screenId: "1"
        };

        deferred = this.workflowLoopedTransitionsAJAXManager.updateLoopedTransition(sentRequestObject);
        this.sandbox.server.respondWith(contextPath() + "/rest/workflowDesigner/latest/workflows/loopedTransitions", [200, {}, ""]);
        this.sandbox.server.respond();

        actualRequestObject = TestUtilities.getRequestBodyAsObject(this.sandbox.server.requests[0].requestBody);
        deepEqual(actualRequestObject, sentRequestObject, "The request body for update was correct.");
        equal(deferred.state(), "resolved", "The returned deferred was resolved.");
    });

    test("updateLoopedTransition() rejects the returned deferred on error", function () {
        var deferred = this.workflowLoopedTransitionsAJAXManager.updateLoopedTransition({
            transitionId: 100,
            name: "name",
            description: "description",
            workflowName: "Workflow",
            screenId: 1
        });

        TestUtilities.respondWithErrorAndAssertRejected(
            deferred, "/rest/workflowDesigner/latest/workflows/loopedTransitions", this.sandbox.server);
    });

});
