define("workflow-designer/io/ajax/user-properties-ajax-manager", [
    "workflow-designer/io/ajax/ajax-manager",
    "workflow-designer/io/error-handler",
    "workflow-designer/underscore",
    "jquery",
    "wrm/context-path"
], function(
    AJAXManager,
    ErrorHandler,
    _,
    jQuery,
    contextPath
) {
    var URL = contextPath() + "/rest/workflowDesigner/latest/userProperties";

    /**
     * Handles getting/setting user properties via AJAX.
     *
     * @namespace
     * @extends JIRA.WorkflowDesigner.IO.AJAX.Manager
     */
    return new (AJAXManager.extend(/** @lends JIRA.WorkflowDesigner.IO.AJAX.UserPropertiesAJAXManager */{
        /**
         * Get a user property.
         *
         * @param {string} key The property to get.
         * @returns {jQuery.Deferred} A deferred that is resolved on success.
         */
        getProperty: function (key) {
            var deferred = jQuery.Deferred(),
                request;

            request = this._makeRequest({
                data: {
                    key: key
                },
                dataType: "json",
                url: URL
            });

            request.done(deferred.resolve);
            request.fail(function (response, status) {
                deferred.reject(ErrorHandler.getErrorMessage(response, status));
            });

            return deferred.promise();
        },

        /**
         * Set a user property.
         *
         * @param {string} key The property to set.
         * @param {*} value The value to set it to.
         * @returns {jQuery.Deferred} A deferred that is resolved on success.
         */
        setProperty: function (key, value) {
            var deferred = jQuery.Deferred(),
                request;

            request = this._makeRequest({
                contentType: "application/json",
                data: JSON.stringify({
                    key: key,
                    value: value
                }),
                type: "POST",
                url: URL
            });

            request.done(deferred.resolve);
            request.fail(function (response, status) {
                deferred.reject(ErrorHandler.getErrorMessage(response, status));
            });

            return deferred.promise();
        }
    }))();
});

AJS.namespace("JIRA.WorkflowDesigner.IO.AJAX.UserPropertiesAJAXManager", null, require("workflow-designer/io/ajax/user-properties-ajax-manager"));