AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var UserPropertiesAJAXManager = require("workflow-designer/io/ajax/user-properties-ajax-manager");
    var contextPath = require("wrm/context-path");

    module("UserPropertiesAJAXManager", {
        setup: function () {
            this.server = sinon.fakeServer.create();
            this.URL = contextPath() + "/rest/workflowDesigner/latest/userProperties";
            this.userPropertiesAJAXManager = UserPropertiesAJAXManager;
        },

        teardown: function () {
            this.server.restore();
        }
    });

    test("getProperty()", function () {
        var deferred = this.userPropertiesAJAXManager.getProperty("key"),
            response = {key: "key", value: "value"},
            URL = this.URL + "\\?key=key";

        this.server.respondWith(new RegExp(URL), JSON.stringify(response));
        this.server.respond();

        equal(this.server.requests.length, 1, "An AJAX request was made to retrieve the property");
        equal(deferred.state(), "resolved", "The returned deferred was resolved");
        deferred.done(function (property) {
            deepEqual(property, response, "It was resolved with the correct information");
        });
    });

    test("getProperty() rejects the returned deferred on error", function () {
        var deferred = this.userPropertiesAJAXManager.getProperty("key"),
            URL = this.URL + "\\?key=key";

        this.server.respondWith(new RegExp(URL), [400, {}, "Nope!"]);
        this.server.respond();

        equal(deferred.state(), "rejected", "The returned deferred was rejected");
        deferred.fail(function (errorMessage) {
            equal(errorMessage, "Nope!", "It was rejected with the error message");
        });
    });

    test("setProperty()", function () {
        var deferred = this.userPropertiesAJAXManager.setProperty("key", "value"),
            expectedRequestBody;

        this.server.respond(this.URL, [200, {}, ""]);
        this.server.respond();

        expectedRequestBody = JSON.stringify({
            key: "key",
            value: "value"
        });

        equal(this.server.requests.length, 1, "An AJAX request was made to set the property");
        equal(this.server.requests[0].requestBody, expectedRequestBody, "The request body is correct");
        equal(deferred.state(), "resolved", "The returned deferred was resolved");
    });

    test("setProperty() rejects the returned deferred on error", function () {
        var deferred = this.userPropertiesAJAXManager.setProperty("key", "value");

        this.server.respondWith(this.URL, [400, {}, "Nope!"]);
        this.server.respond();

        equal(deferred.state(), "rejected", "The returned deferred was rejected");
        deferred.fail(function (errorMessage) {
            equal(errorMessage, "Nope!", "It was rejected with the error message");
        });
    });

});
