AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-io",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {

    var StatusCategoriesAJAXManager = require("workflow-designer/io/ajax/status-categories-ajax-manager");
    var contextPath = require("wrm/context-path");

    module("StatusCategoriesAJAXManager", {
        setup: function () {
            this.server = sinon.fakeServer.create();
            this.statusCategoriesAJAXManager = StatusCategoriesAJAXManager;
            this.URL = contextPath() + "/rest/workflowDesigner/latest/statusCategories";
        },

        teardown: function () {
            this.statusCategoriesAJAXManager.reset();
            this.server.restore();
        }
    });

    test("getStatusCategories()", function () {
        var deferred = this.statusCategoriesAJAXManager.getStatusCategories(),
            response;

        response = [{
            colorName: "medium-gray",
            id: 1,
            key: "undefined",
            name: "No Category"
        }, {
            colorName: "blue-gray",
            id: 2,
            key: "new",
            name: "New"
        }];

        this.server.respondWith(new RegExp(this.URL), JSON.stringify(response));
        this.server.respond();

        equal(this.server.requests.length, 1, "An AJAX request was make to retrieve the status categories");
        equal(deferred.state(), "resolved", "The returned deferred was resolved");
        deferred.done(function (statusCategories) {
            deepEqual(statusCategories, response, "It is resolved with the status category information");
        });

        // The response should be cached.
        deferred = this.statusCategoriesAJAXManager.getStatusCategories();

        equal(this.server.requests.length, 1, "Subsequent calls don't result in an AJAX request");
        equal(deferred.state(), "resolved", "The returned deferred is resolved immediately");
        deferred.done(function (statusCategories) {
            deepEqual(statusCategories, response, "It is resolved with the status category information");
        });

        // Calling reset() should clear the cache.
        this.statusCategoriesAJAXManager.reset();
        deferred = this.statusCategoriesAJAXManager.getStatusCategories();
        this.server.respond();

        equal(this.server.requests.length, 2, "reset() clears the cached response");
        equal(deferred.state(), "resolved", "The returned deferred was resolved");
    });

    test("getStatusCategories() rejects the returned deferred on error", function () {
        var deferred = this.statusCategoriesAJAXManager.getStatusCategories();

        this.server.respondWith(new RegExp(this.URL), [400, {}, "Nope."]);
        this.server.respond();

        equal(deferred.state(), "rejected", "The returned deferred was rejected");
        deferred.fail(function (errorMessage) {
            equal(errorMessage, "Nope.", "It was rejected with the error message");
        });
    });

});
