define("workflow-designer/io/ajax/screens-ajax-manager", [
    "workflow-designer/io/ajax/ajax-manager",
    "workflow-designer/io/error-handler",
    "workflow-designer/underscore",
    "jquery",
    "wrm/context-path"
], function(
    AJAXManager,
    ErrorHandler,
    _,
    jQuery,
    contextPath
) {
    /**
     * Cache for screens
     *
     * @inner
     * @type {Object|undefined}
     */
    var screens;

    /**
     * Handles retrieving screens via AJAX.
     *
     * @namespace
     * @extends JIRA.WorkflowDesigner.IO.AJAX.AJAXManager
     */
    return new (AJAXManager.extend(/** @lends JIRA.WorkflowDesigner.IO.AJAX.ScreensAJAXManager */{
        /**
         * Retrieve information about all screens in the system.
         *
         * @return {jQuery.Deferred} A deferred that is resolved with screen data.
         */
        getScreens: function () {
            var deferred = jQuery.Deferred(),
                request;

            if (screens) {
                deferred.resolve(screens);
            } else {
                request = this._makeRequest({
                    dataType: "json",
                    url: contextPath() + "/rest/workflowDesigner/latest/screens"
                });

                request.done(function (response) {
                    screens = response;
                    deferred.resolve(screens);
                });

                request.fail(function (response, status) {
                    deferred.reject(ErrorHandler.getErrorMessage(response, status));
                });
            }

            return deferred.promise();
        },

        /**
         * Reset the manager, clearing its cache.
         */
        reset: function () {
            screens = undefined;
        }
    }))();
});

AJS.namespace("JIRA.WorkflowDesigner.IO.AJAX.ScreensAJAXManager", null, require("workflow-designer/io/ajax/screens-ajax-manager"));