AJS.test.require([
    "com.atlassian.jira.plugins.jira-workflow-designer:workflow-designer-io",
    "com.atlassian.jira.plugins.jira-workflow-designer:test-resources"
], function () {
    
    var ScreensAJAXManager = require("workflow-designer/io/ajax/screens-ajax-manager");
    var contextPath = require("wrm/context-path");

    module("ScreensAJAXManager", {
        setup: function () {
            this.server = sinon.fakeServer.create();
            this.screensAJAXManager = ScreensAJAXManager;
        },

        teardown: function () {
            this.screensAJAXManager.reset();
            this.server.restore();
        }
    });

    test("getScreens()", function () {
        var deferred = this.screensAJAXManager.getScreens(),
            response = [{name: "Screen 1"}, {name: "Screen 2"}],
            URL = contextPath() + "/rest/workflowDesigner/latest/screens";

        this.server.respondWith(new RegExp(URL), JSON.stringify(response));
        this.server.respond();

        equal(this.server.requests.length, 1, "An AJAX request was made to retrieve the screens");
        equal(deferred.state(), "resolved", "The returned deferred was resolved");
        deferred.done(function (screens) {
            deepEqual(screens, response, "It was resolved with screen information");
        });

        // The response should be cached.
        deferred = this.screensAJAXManager.getScreens();

        equal(this.server.requests.length, 1, "Subsequent calls don't result in an AJAX request");
        equal(deferred.state(), "resolved", "The returned deferred is resolved immediately");
        deferred.done(function (screens) {
            deepEqual(screens, response, "It is resolved with screen information");
        });

        // Calling reset() should clear the cache.
        this.screensAJAXManager.reset();
        deferred = this.screensAJAXManager.getScreens();
        this.server.respond();

        equal(this.server.requests.length, 2, "reset() clears the cached response");
        equal(deferred.state(), "resolved", "The returned deferred was resolved");
    });

    test("getScreens() rejects the returned deferred on error", function () {
        var deferred = this.screensAJAXManager.getScreens(),
            URL = contextPath() + "/rest/workflowDesigner/latest/screens";

        this.server.respondWith(new RegExp(URL), [400, {}, "No deal."]);
        this.server.respond();

        equal(deferred.state(), "rejected", "The returned deferred was rejected");
        deferred.fail(function (errorMessage) {
            equal(errorMessage, "No deal.", "It was rejected with the error message");
        });
    });

});
